<?php

namespace Wi\Admin\NewsLetterBundle\Controller;

use Wi\Admin\NewsLetterBundle\Entity\Senders;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Wi\Admin\NewsLetterBundle\Form\SendersType;
use Wi\Admin\NewsLetterBundle\Form\SendersDeleteType;


/**
 * Sender controller.
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class SendersController extends Controller
{
    /**
     * Lists all sender entities.
     *
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $senders = $em->getRepository('WiAdminNewsLetterBundle:Senders')->findAll();

        return $this->render('WiAdminNewsLetterBundle:Senders:index.html.php', array(
            'senders' => $senders,
        ));
    }

    /**
     * Creates a new sender entity.
     *
     */
    public function newAction(Request $request)
    {
         // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();

        $campaign = $em->getRepository('WiAdminNewsLetterBundle:Campaign')->find($request->query->getInt('cid'));

        // Utworzenie nowego obiektu pytań.
        $sender = new Senders();

        // Generowanie formularza.
        $form = $this->createForm(SendersType::class, $sender);
        $form->handleRequest($request);

        // Weryfikacja, czy formularz został przesłany i pomyślnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
            if (! is_null($campaign)) {
                $campaign->addSender($sender);
                $em->persist($campaign);
            }

            // Zapis.
            $em->persist($sender);
            $em->flush();

            return $this->redirectToRoute('wi_admin_newsletter_senders_show', [
                'id' => $sender->getId(),
            ]);
        }

        return $this->render('WiAdminNewsLetterBundle:Senders:new.html.php', [
            'form' => $form->createView(),
            'sender' => $sender,
        ]);
    }

    /**
     * Finds and displays a sender entity.
     *
     */
    public function showAction(Senders $sender)
    {

        return $this->render('WiAdminNewsLetterBundle:Senders:show.html.php', array(
            'sender' => $sender,
        ));
    }

    /**
     * Displays a form to edit an existing sender entity.
     *
     */
    public function editAction(Request $request, Senders $sender)
    {
        // Generowanie formularza.
        $form = $this->createForm(SendersType::class, $sender);
        $form->handleRequest($request);

        // Weryfikacja, czy formularz został przesłany i pomyślnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
            // Utworzenie instancji EntityManager-a.
            $em = $this->getDoctrine()->getManager();

            // Zapis.
            $em->persist($sender);
            $em->flush();

            return $this->redirectToRoute('wi_admin_newsletter_mainsite_index');
        }

        return $this->render('WiAdminNewsLetterBundle:Senders:edit.html.php', [
            'form' => $form->createView(),
            'sender' => $sender,
        ]);
    }

    /**
     * Deletes a sender entity.
     *
     */
    public function deleteAction(Request $request, Senders $sender)
    {
        // Generowanie formularza.
        $deleteForm = $this->createForm(SendersDeleteType::class);
        $deleteForm->handleRequest($request);

        // Weryfikacja czy formularz został przesłany i pomyślnie zwalidowany.
        if ($deleteForm->isSubmitted() && $deleteForm->isValid()) {
            // Utworzenie instancji EntityManager-a.
            $em = $this->getDoctrine()->getManager();

            // Usunięcie.
            $em->remove($sender);
            $em->flush();

            return $this->redirectToRoute('wi_admin_newsletter_mainsite_index');
        }

        return $this->render('WiAdminNewsLetterBundle:Senders:delete.html.php', [
            'deleteForm' => $deleteForm->createView(),
            'sender' => $sender,
        ]);
    }
}
