<?php

namespace Wi\Admin\NewsLetterBundle\Controller;

use Knp\Component\Pager\Paginator;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

/**
 * Mainsite Newsletter controller.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class NewsletterController extends Controller
{
    /**
     * Widok główny systemu mailingowego.
     *
     * @param Request $request
     * @param Paginator $paginator
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction(Request $request, Paginator $paginator)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();
        $campaignRepo = $em->getRepository('WiAdminNewsLetterBundle:Campaign');

        $activeCampaigns = $campaignRepo->getFindAllActive();
        $notActiveCampaigns = $paginator->paginate(
            $campaignRepo->getFindAllNotActiveQuery(),
            $request->query->getInt('page', 1),
            $request->query->getInt('per_page') ?: 10
        );
        $config = $this->getConfig();
        $recipientGroups = $em->getRepository('WiAdminNewsLetterBundle:RecipientGroup')->findAll();
        $senders = $em->getRepository('WiAdminNewsLetterBundle:Senders')->findAll();

        return $this->render('WiAdminNewsLetterBundle:Newsletter:index.html.php', [
            'activeCampaigns' => $activeCampaigns,
            'config' => $config,
            'notActiveCampaigns' => $notActiveCampaigns,
            'recipientGroups' => $recipientGroups,
            'senders' => $senders,
        ]);
    }

    /**
     *
     * @param Request $request
     * @return JsonResponse
     */
    public function statisticsAction(Request $request)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();
        $out = [
            'data' => [],
        ];

        $dateEnd = new \DateTime();
        $dateStart = (new \DateTime($dateEnd->format('Y-m-d')))->modify('-1 months');
        $all = $em->getRepository('WiAdminNewsLetterBundle:ViewNewsletterStatsPerDay')
            ->findBetweenDates($dateStart, $dateEnd)
        ;

        while ($dateStart <= $dateEnd) {
            $out['data'][$dateStart->format('Y-m-d')] = [
                'date' => $dateStart->format('Y-m-d'),
                'messages' => 0,
                'tooltip' => '',
            ];
            $dateStart->modify('+1 day');
        }

        foreach ($all as $one) {
            if (isset($out['data'][$one->getDate()])) {
                $out['data'][$one->getDate()]['messages'] += (int) $one->getMessages();
                $out['data'][$one->getDate()]['tooltip'] = '<div style="padding:5px;white-space:nowrap;">Day: '.$one->getDate().'<br>Sent: '.(int) $out['data'][$one->getDate()]['messages'].' messages.</div>';
            } else {
                $out['data'][$one->getDate()] = [
                    'date' => $one->getDate(),
                    'messages' => (int) $one->getMessages(),
                ];
                $out['data'][$one->getDate()]['tooltip'] = '<div style="padding:5px;white-space:nowrap;">Day: '.$one->getDate().'<br>Sent: '.(int) $out['data'][$one->getDate()]['messages'].' messages.</div>';

            }

        }

        $out['data'] = array_values($out['data']);

        return new JsonResponse($out);
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Pobiera konfiguracje.
     *
     * @return array
     */
    private function getConfig()
    {
        $configRepo = $this->getDoctrine()->getManager()
            ->getRepository('WiAdminNewsLetterBundle:Config')
        ;

        return [
            'enable_newsletter' => $configRepo->getEnableNewsletter(),
        ];
    }
}
