<?php

namespace Wi\Admin\NewsLetterBundle\Command\SQL;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class CreateViewCommand extends ContainerAwareCommand
{
    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this
            ->setName('app:doctrine:newsletter:create-view')
            ->setDescription('Utworz widok SQL dla modulu Newsletter.')
            ->setHelp('Tworzy widok SQL dla modulu Newsletter wykorzytywany dla statystyk.')
        ;
    }

    /**
     * {@inheritdoc}
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $output->writeln('Tworzenie widoku SQL dla statystyk Newslettera.');
        $em = $this->getContainer()->get('doctrine.orm.entity_manager');
        $conn = $em->getConnection();
        $statsPerDayTable = $em->getClassMetadata('WiAdminNewsLetterBundle:ViewNewsletterStatsPerDay')->getTableName();
        $statsPerHourTable = $em->getClassMetadata('WiAdminNewsLetterBundle:ViewNewsletterStatsPerHour')->getTableName();

        $sql = "DROP TABLE IF EXISTS $statsPerDayTable";
        $stmt = $conn->prepare($sql);
        $res = $stmt->execute();

        if ($res) {
            $output->writeln('Usunieto tabele: <info>' . $statsPerDayTable . '</info>');
        }

        $sql = "DROP TABLE IF EXISTS $statsPerHourTable";
        $stmt = $conn->prepare($sql);
        $res = $stmt->execute();

        if ($res) {
            $output->writeln('Usunieto tabele: <info>' . $statsPerHourTable . '</info>');
        }

        $sqlView = "CREATE VIEW `$statsPerDayTable` AS SELECT l.campaign_id, DATE_FORMAT(l.date_message, '%Y-%m-%d') AS `date`, COUNT(l.id) AS messages FROM newsletter_logs l GROUP BY l.campaign_id, `date` ORDER BY l.campaign_id, `date`;";
        $stmt = $conn->prepare($sqlView);
        $res = $stmt->execute();

        if ($res) {
            $output->writeln('Utworzono widok: <info>' . $statsPerDayTable . '</info>');
        }

        $sqlView = "CREATE VIEW `$statsPerHourTable` AS SELECT l.campaign_id, DATE_FORMAT(l.date_message, '%Y-%m-%d') AS `date`, DATE_FORMAT(l.date_message, '%H') AS `hour`, COUNT(l.id) AS messages FROM newsletter_logs l GROUP BY l.campaign_id, `date`, `hour` ORDER BY l.campaign_id, `date`, `hour`;";
        $stmt = $conn->prepare($sqlView);
        $res = $stmt->execute();

        if ($res) {
            $output->writeln('Utworzono widok: <info>' . $statsPerHourTable . '</info>');
        }
    }
}
