<?php

namespace Wi\Admin\NewsBundle\Service;

use Symfony\Bundle\FrameworkBundle\Templating\EngineInterface;
use Wi\Admin\PdfBundle\Service\Pdf as BasePdf;
use Wi\Admin\CoreBundle\Service\Config;
use Wi\Admin\NewsBundle\Entity\News;

class Pdf extends BasePdf
{
    const FORMAT = '@templates/%s/view/%s.html.twig';

    private $config;
    private $templating;

    private $news;

    public function __construct(Config $config, EngineInterface $templating)
    {
        $this->config = $config;
        $this->templating = $templating;

        parent::__construct([
            'margin_left' => 10,
            'margin_right' => 10,
            'margin_top' => 10,
            'margin_bottom' => 10,
        ]);

        // Linki do CSS.
        $this->setCss([]);
    }

    public function setNews(News $news)
    {
        $this->news = $news;

        $this
            ->setTitle($news->getTitle())
            ->setOptions([
                'filename' => $news->getTitle() . '.pdf',
                'destination' => 'I',
            ])
        ;

        return $this;
    }

    public function html() : string
    {
        return $this->templating
            ->render($this->getTemplate('News/Pdf/pdf'), [
                'news' => $this->news,
            ])
        ;
    }

    public function getTemplate(string $template) : string
    {
        if (! $this->templating->exists($path = sprintf(self::FORMAT, $this->config->getParameter('template_name'), $template))) {
            return sprintf(self::FORMAT, $this->config->getParameter('default_template_name'), $template);
        }

        return $path;
    }
}
