<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_news_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.news.newsList')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css') ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css') ?>"  rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/news.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"  rel="stylesheet" type="text/css" />
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_news_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.news.newsList'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-newspaper-1"></i><?php echo $view['translator']->trans('news.listTitle'); ?> - <?php echo $view['translator']->trans('newsList.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('newsList.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>
    <?php echo $view['translator']->trans('helpRightPanel.newsIndex'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
    <?php
    /**
     * Przetwarza drzewo zagnieżdżeń kategorii i wypisuje do selecta.
     *
     * @param   Category[]  $categories
     * @param   string      $prefix
     */
    $categoriesChoices = [];

    $createTree = function ($categories, $prefix = ' ') use (&$createTree, &$categoriesChoices) {
        foreach ($categories as $category) {
            // Pole label jest tworzone dynamicznie tylko na potrzeby wypisania etykiety.
            $category->label = $prefix . $category->getName();

            $categoriesChoices[] = $category;

            if ($category->getChildren()->count()) {
                $createTree($category->getChildren(), '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $prefix);
            }
        }

    };

    $createTree($categories);

    $addNewNewsParamsLink = [];

    if ($view['request']->getParameter('category_id')) {
        $addNewNewsParamsLink['category_id'] = $view['request']->getParameter('category_id');
    }
    ?>

    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configCategory-dropdown">
                    <i class="icon-cog-5"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configCategory-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <?php if ($view['security']->isGranted('ROLE_NEWS_EDIT')): ?>
                            <li>
                                <a href="<?php echo $view['router']->path('wi_admin_news_categories_new') ?>"  title="<?php echo $view['translator']->trans('newsList.addNewCategory'); ?>">
                                    <span><i class="icon-folder-add"></i> <?php echo $view['translator']->trans('newsList.addNewCategory'); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if ($view['request']->getParameter('category_id')): ?>
                            <li>
                                <a href="<?php echo $view['router']->path('wi_admin_news_categories_show', ['id' => $view['request']->getParameter('category_id')]) ?>" title="<?php echo $view['translator']->trans('newsList.editCategory'); ?>">
                                    <span><i class="icon-folder-open-empty"></i> <?php echo $view['translator']->trans('newsList.editCategory'); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <li>
                            <a href="<?php echo $view['router']->path('wi_admin_news_categories_index') ?>" title="<?php echo $view['translator']->trans('newsList.menageCategory'); ?>">
                                <span><i class="icon-folder-2"></i> <?php echo $view['translator']->trans('newsList.menageCategory'); ?></span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <h3 class="box-title"><i class="icon-filter"></i>
                <span><?php echo $view['translator']->trans('newsList.selectCategory'); ?>:</span>
            </h3>
            <form method="get" id="selectCategoryForm">
                <?php
                $knp_params = $news->getParams();

                if (isset($knp_params['category_id'])) {
                    unset($knp_params['category_id']);
                }
                ?>
                <?php foreach ($knp_params as $param => $value): ?>
                    <input type="hidden" name="<?php echo $param; ?>" value="<?php echo $value; ?>">
                <?php endforeach; ?>
                <label>
                    <select name="category_id" class="selectCategory">
                        <option value=""><?php echo $view['translator']->trans('newsList.selectCategoryAll'); ?></option>
                        <?php foreach ($categoriesChoices as $category): ?>
                            <option value="<?php echo $category->getId(); ?>" <?php echo $category->getId() != $view['request']->getParameter('category_id') ? '' : 'selected'; ?>><?php echo $category->label; ?></option>
                        <?php endforeach; ?>
                    </select>
                </label>
            </form>
            <?php if(! is_null($view['request']->getParameter('category_id'))): ?>
                <a class="clearFilter" href="<?php echo $view['router']->path('wi_admin_news_index') ?>" title="<?php echo $view['translator']->trans('newsList.clearFilter'); ?>"><i class="icon-cancel"></i></a>
            <?php endif; ?>
        </div>
    </div>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configNews-dropdown">
                    <i class="icon-cog-5"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configNews-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_NEWS_EDIT')): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_news_new', $addNewNewsParamsLink) ?>" title="<?php echo $view['translator']->trans('newsList.add'); ?>">
                                    <span><i class="icon-doc-add"></i> <?php echo $view['translator']->trans('newsList.add'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                    </ul>
                </div>
            </div>
            <h3 class="box-title"><i class="icon-newspaper-1"></i>
                <span><?php echo $view['translator']->trans('newsList.listSubTitle'); ?></span>
            </h3>
            <div class="ListNewsSearch">
                <?php echo $view->render('KnpPaginatorBundle/Pagination/search.html.php', [
                    'knp_pagination' => $news,
                ]); ?>
            </div>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="columns ">
                    <?php if ($view['security']->isGranted('ROLE_NEWS_EDIT')): ?>
                        <a href="<?php echo $view['router']->path('wi_admin_news_new', $addNewNewsParamsLink) ?>" title="<?php echo $view['translator']->trans('newsList.add'); ?>" class="button primary newsListNewTop">
                            <i class="icon-doc-add"></i> <?php echo $view['translator']->trans('newsList.add'); ?>
                        </a>
                    <?php endif; ?>
                </div>
                <div class="columns tableResp">
                    <table id="newsList" class="display" style="width:100%">
                        <thead>
                        <tr>
                            <th><?php echo $view['knp_pagination']->sortable($news, $view['translator']->trans('newsList.table.id'), 'n.id'); ?></th>
                            <th><?php echo $view['translator']->trans('newsList.table.image'); ?></th>
                            <th><?php echo $view['knp_pagination']->sortable($news, $view['translator']->trans('newsList.table.title'), 'n.title'); ?></th>
                            <th><?php echo $view['translator']->trans('newsList.table.short'); ?></th>
                            <th><?php echo $view['translator']->trans('newsList.table.category'); ?></th>
                            <th><?php echo $view['knp_pagination']->sortable($news, $view['translator']->trans('newsList.table.date'), 'n.dateOfPublication'); ?></th>
                        </tr>
                        </thead>

                        <tbody>
                        <?php foreach ($news as $itemNews): ?>
                            <tr>
                                <td><?php echo $itemNews->getId(); ?>
                                </td>
                                <td>
                                    <div class="imgThmbnail <?php echo ($itemNews->getImageUrl() ? 'nonebackground' : ''); ?>" placeholder="no image">
                                        <?php if ($itemNews->getImageUrl()): ?>
                                        <a href="<?php echo $view['router']->path('wi_admin_news_show', ['id' => $itemNews->getId()]); ?>">
                                            <img class="imgListBanner thumbnail" src="<?php echo $view['assets']->getUrl('media/assets/News/thumbnail/'.$itemNews->getImageUrl()); ?>" alt="<?php echo $itemNews->getTitle(); ?>">
                                        </a>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td><a href="<?php echo $view['router']->path('wi_admin_news_show', ['id' => $itemNews->getId()]); ?>"><b><?php echo $itemNews->getTitle(); ?></b></a>
                                    <div class="buttonItemsBox">
                                        <div class="buttonsItems">
                                            <a href="<?php echo $view['router']->path('wi_admin_news_show', ['id' => $itemNews->getId()]); ?>" class=""><i class="icon-eye-1"></i><?php echo $view['translator']->trans('Table.showButton'); ?></a> /
                                            <?php if ($view['security']->isGranted('ROLE_NEWS_EDIT')): ?>
                                                <a href="<?php echo $view['router']->path('wi_admin_news_edit', ['id' => $itemNews->getId()]); ?>" class=""><i class="icon-edit-1"></i><?php echo $view['translator']->trans('Table.editButton'); ?></a> /
                                            <?php endif; ?>
                                            <?php if ($view['security']->isGranted('ROLE_NEWS_EDIT')): ?>
                                                <a href="<?php echo $view['router']->path('wi_admin_news_delete', ['id' => $itemNews->getId()]); ?>" class=""><i class="icon-cancel-circled-outline"></i><?php echo $view['translator']->trans('Table.deleteButton'); ?></a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </td>
                                <td><?php echo substr(trim(strip_tags($itemNews->getShortcut())),0,200); ?> <?php echo (strlen(trim(strip_tags($itemNews->getShortcut())))>200 ? "..." : ""); ?></td>
                                <td class="showCategoryNews">
                                        <?php foreach ($itemNews->getCategories() as $category): ?>
                                            <span class="info label secondary showNewsButton tiny"><?php echo $category->getName(); ?></span>
                                        <?php endforeach; ?>
                                </td>
                                <td>
                                    <?php if ($itemNews->getDateCreated()): ?>
                                        <?php echo $itemNews->getDateCreated()->format('Y-m-d H:i:s'); ?>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="row">
                <div class="medium-6 columns">
                    <?php if ($view['security']->isGranted('ROLE_NEWS_EDIT')): ?>
                        <a href="<?php echo $view['router']->path('wi_admin_news_new', $addNewNewsParamsLink) ?>" title="<?php echo $view['translator']->trans('newsList.add'); ?>" class="button primary newsListNew">
                            <i class="icon-doc-add"></i> <?php echo $view['translator']->trans('newsList.add'); ?>
                        </a>
                    <?php endif; ?>
                </div>
                <div class="medium-6 columns paginationBox">
                    <?php echo $view->render('KnpPaginatorBundle/Pagination/per_page.html.php', [
                        'knp_pagination' => $news,
                    ]); ?>

                    <?php echo $view['knp_pagination']->render($news); ?>
                </div>
            </div>
        </div>
    </div>
    <script>
        var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
    </script>
<?php $view['slots']->stop() ?>


<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/news.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
