<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_news_comment_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('comment.meta.title', [], 'news_comment')) ?>

<?php $view['slots']->start('stylesheets') ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/news.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.cmsAdvanced'); ?>
    </li>
    <li><a href="<?php echo $view['router']->path('wi_admin_news_comment_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.comment', [], 'news_comment'); ?></a></li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_news_comment_edit', ['id' => $comment->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.edit', [], 'news_comment'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
<i class="icon-comment-empty"></i><?php echo $view['translator']->trans('comment.edit_title', [], 'news_comment'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
<?php echo $view['form']->start($form); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <h3 class="box-title">
            <i class="icon-comment-empty"></i>
            <span><?php echo $view['translator']->trans('comment.edit_title', [], 'news_comment'); ?>:</span>
        </h3>
    </div>
    <div class="box-body " style="display: block;">
        <?php if (! is_null($comment->getGuest())): ?>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('comment.form.guest.name.title', [], 'news_comment'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('comment.form.guest.name.desc', [], 'news_comment'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-12 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['guestName']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['guestName']) ? $view['form']->widget($form['guestName'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['guestName'])); ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif ?>

        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('comment.form.content.title', [], 'news_comment'); ?></strong></p>
                <p><?php echo $view['translator']->trans('comment.form.content.desc', [], 'news_comment'); ?></p>
            </div>
            <div class="large-10 columns">
                <div class="row">
                    <div class="medium-12 columns end">
                        <div class="formAlert">
                            <?php echo $view['form']->errors($form['content']); ?>
                        </div>
                        <?php echo ($view['form']->errors($form['content']) ? $view['form']->widget($form['content'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['content'])); ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('comment.form.status.title', [], 'news_comment'); ?></strong></p>
                <p><?php echo $view['translator']->trans('comment.form.status.desc', [], 'news_comment'); ?></p>
            </div>
            <div class="large-10 columns">
                <div class="row">
                    <div class="medium-12 columns end">
                        <div class="formAlert">
                            <?php echo $view['form']->errors($form['status']); ?>
                        </div>
                        <?php echo ($view['form']->errors($form['status']) ? $view['form']->widget($form['status'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['status'])); ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="large-2 columns"></div>
            <div class="large-10 columns">
                <div class="news-add-form">
                    <?php echo $view['form']->widget($form); ?>
                    <button class="button" href="#" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
                        <i class="icon-edit"></i>
                        <?php echo $view['translator']->trans('Form.send'); ?>
                    </button>
                    <?php echo $view['form']->end($form); ?>
                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_news_comment_index'); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php echo $view['form']->end($form); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/news.js') ?>"></script>
<?php $view['slots']->stop() ?>
