<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_blog_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.categoryBlog.catShow')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/news.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_blog_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.news.news'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_blog_categories_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.categoryBlog.catList'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_blog_categories_show', array('id' => $category->getId())); ?>"><?php echo $view['translator']->trans('breadcrumbs.categoryBlog.catShow'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-newspaper-1"></i><?php echo $view['translator']->trans('blog.listTitle'); ?> - <?php echo $view['translator']->trans('catBlogShow.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('catBlogShow.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configShowCategory-dropdown">
                    <i class="icon-cog-5"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configShowCategory-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_BLOG_EDIT')): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_blog_categories_edit', array('id' => $category->getId())); ?>" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                                    <span><i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_BLOG_EDIT')): ?>
                                <a
                                   href="<?php echo $view['router']->path('wi_admin_blog_categories_delete', ['id' => $category->getId()]); ?>">
                                    <span><i class="icon-cancel-circled"></i><?php echo $view['translator']->trans('catBlogShow.deleteButton'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                    </ul>
                </div>
            </div>
            <h3 class="box-title"><i class="icon-folder"></i>
                <span><?php echo $view['translator']->trans('catBlogShow.listSubTitle'); ?> - <?php echo $category->getName(); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('catBlogShow.details'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('catBlogShow.detailsDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <p><strong><?php echo $view['translator']->trans('catBlogShow.name'); ?>:</strong> <?php echo $category->getName(); ?></p>
                    <p><strong><?php echo $view['translator']->trans('catBlogShow.OrderNr'); ?>:</strong> <?php echo $category->getOrderNr(); ?></p>
                    <p><strong><?php echo $view['translator']->trans('catBlogShow.DateCreated'); ?>:</strong>
                        <?php if ($category->getDateCreated()): ?>
                            <?php echo $category->getDateCreated()->format('Y-m-d H:i:s'); ?>
                        <?php endif; ?>
                    </p>
                    <p><strong><?php echo $view['translator']->trans('catBlogShow.description'); ?>:</strong></p>
                    <p class="callout"><?php echo $category->getDescription(); ?></p>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="columns">
                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_blog_categories_index'); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/news.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop(); ?>
