<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_blog_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.categoryBlog.catDelete')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/news.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_blog_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.blog.news'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_blog_categories_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.categoryBlog.catList'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_blog_categories_delete', array('id' => $category->getId())); ?>"><?php echo $view['translator']->trans('breadcrumbs.categoryBlog.catDelete'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-users-outline"></i>
    <?php echo $view['translator']->trans('blog.listTitle'); ?> - <?php echo $view['translator']->trans('catBlogDelete.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('catBlogDelete.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php // Funkcja wyświetlająca dzieci kategorii ?>
<?php function getChildrenView($cat, $view) { ?>
    <ul class="childrenView">
    <?php foreach ($cat as $children): ?>
        <li>
            <?php echo $children->getName().' - '.$children->getNews()->count().' '.$view['translator']->trans('catBlogDelete.countNews'); ?>
            <?php getChildrenView($children->getChildren(), $view); ?>
        </li>
    <?php endforeach; ?>
    </ul>
<?php } ?>

<?php $view['slots']->start('body') ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title"><i class="icon-folder-delete"></i>
                <span><?php echo $view['translator']->trans('catBlogDelete.listSubTitle'); ?> - <?php echo $category->getName() ?> </span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
        <?php echo $view['form']->start($formDelete); ?>
            <p class="catBlogDeleteQuestion"><?php echo $view['translator']->trans('catBlogDelete.confirm'); ?></p>
            <div class="switch-admin">
                <?php echo $view['form']->errors($formDelete['deleteCategory']); ?>
                <?php echo $view['form']->widget($formDelete['deleteCategory']); ?>
                <label class="switch-paddle" for="<?php echo $formDelete->children['deleteCategory']->vars['id']; ?>">
                    <span class="show-for-sr"><?php echo $view['translator']->trans('catBlogDelete.confirm'); ?></span>
                    <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                    <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                </label>
            </div>
            <span id="countNews"  wartosc="<?php echo $category->getNews()->count() ?>"></span>
            <span id="countChildren"  wartosc="<?php echo $category->getChildren()->count() ?>"></span>
            <div class="confirmDelete" id="confirmDelete">
                <?php if($category->getNews()->count()!=0 || $category->getChildren()->count()!=0): ?>
                    <p><?php echo $view['translator']->trans('catBlogDelete.listNews').' '.$category->getNews()->count().' '.$view['translator']->trans('catBlogDelete.countNews') ; ?></p>
                    <?php if($category->getChildren()->count() > 0): ?>
                        <p class="catDeleteQuestion"><?php echo $view['translator']->trans('catBlogDelete.listChildren') ?>:</p>
                        <?php getChildrenView($category->getChildren(), $view); ?>
                    <?php endif; ?>
                    <p class="catDeleteQuestion"><?php echo $view['translator']->trans('catBlogDelete.confirmSubtacegories'); ?></p>
                    <div class="switch-admin">
                        <?php echo $view['form']->errors($formDelete['deleteAll']); ?>
                        <?php echo $view['form']->widget($formDelete['deleteAll']); ?>
                        <label class="switch-paddle" for="<?php echo $formDelete->children['deleteAll']->vars['id']; ?>">
                            <span class="show-for-sr"><?php echo $view['translator']->trans('catBlogDelete.confirmSubtacegories'); ?></span>
                            <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                            <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                        </label>
                    </div>
                <div class="confirmDeleteSubcategories" id="confirmDeleteSubcategories">
                    <p class="catDeleteQuestion"><?php echo $view['translator']->trans('catBlogDelete.noDeleteNews'); ?></p>
                    <div class="radioDeleteCat">
                        <label>
                            <?php echo $view['form']->widget($formDelete['noDeleteNews'][0], ['required' => false]); ?>
                            <span data-tooltip aria-haspopup="true" class="has-tip top" data-disable-hover="false" tabindex="1" title="<?php echo $view['translator']->trans('catBlogDelete.unpinDesc'); ?>">
                                <?php echo $view['translator']->trans('catBlogDelete.unpin'); ?>
                            </span>
                        </label>
                        <label>
                            <?php echo $view['form']->widget($formDelete['noDeleteNews'][1], ['required' => false]); ?>
                            <span data-tooltip aria-haspopup="true" class="has-tip top" data-disable-hover="false" tabindex="1" title="<?php echo $view['translator']->trans('catBlogDelete.changeCatDesc'); ?>">
                                <?php echo $view['translator']->trans('catBlogDelete.changeCat'); ?>
                            </span>
                        </label>
                    </div>
                    <div class="selectCategories" id="selectCategories">
                        <p class="catDeleteQuestion"><?php echo $view['translator']->trans('catBlogDelete.changeSubtacegories'); ?></p>
                        <div class="newCategorySelect">
                            <?php echo $view['form']->errors($formDelete['newCategory']); ?>
                            <?php echo $view['form']->widget($formDelete['newCategory']); ?>
                        </div>
                    </div>
                 </div>
                <?php echo $view['form']->widget($formDelete); ?>
            <?php else: ?>
                <p><?php echo $view['translator']->trans('catBlogDelete.listNews').' '.$category->getNews()->count().' '.$view['translator']->trans('catBlogDelete.countNews') ; ?></p>
            <?php endif; ?>
                <button type="submit" id="CatDeleteInput" class="button alert tiny" value="<?php echo $view['translator']->trans('Form.delete'); ?>" disabled>
                    <i class="icon-cancel-circled"></i> <?php echo $view['translator']->trans('adminDelete.delete'); ?>
                </button>
        </div>
            <?php echo $view['form']->end($formDelete); ?>
            <div class="row navigationBottom">
                <div class="columns">
                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_blog_categories_show', array('id' => $category->getId())); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                    </a>
                </div>
            </div>
        </div>
        <!-- end .timeline -->
    </div>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/news.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
