<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_blog_index')); ?>


<?php $view['slots']->set('title', $view['translator']->trans('title.blog.newsShow')) ?>

<?php $view['slots']->start('stylesheets') ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/news.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/jquery.plupload.queue/css/jquery.plupload.queue.css') ?>">
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_blog_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.blog.news'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_blog_show', ['id' => $news->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.blog.newsShow'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-newspaper-1"></i><?php echo $view['translator']->trans('blog.listTitle'); ?> - <?php echo $view['translator']->trans('blogShow.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('blogShow.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configShowNews-dropdown">
                    <i class="icon-cog-5"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configShowNews-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                    <?php if ($view['security']->isGranted('ROLE_BLOG_EDIT')): ?>
                        <li>
                            <a href="<?php echo $view['router']->path('wi_admin_blog_edit', array('id' => $news->getId())); ?>" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                                <span><i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?></span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo $view['router']->path('wi_admin_blog_delete', ['id' => $news->getId()]); ?>">
                                <span><i class="icon-cancel-circled"></i><?php echo $view['translator']->trans('blogShow.deleteButton'); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')): ?>
                        <li>
                            <a data-open="save-as-newsletter-message-modal">
                                <span><i class="icon-mail"></i><?php echo $view['translator']->trans('newsShow.saveAsNewsletterMessage'); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>
                        <li>
                            <a href="<?php echo $view['router']->path('wi_admin_news_pdf', ['id' => $news->getId()]); ?>">
                                <span><i class="icon-file-pdf"></i><?php echo $view['translator']->trans('Form.SavePDF'); ?></span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <h3 class="box-title"><i class="icon-doc-text-1"></i>
                <span><?php echo $view['translator']->trans('catShow.listSubTitle'); ?> - <?php echo $news->getTitle(); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row showNews">
                <div class="large-2 columns">
                    <div class="imgThumbnail <?php echo($news->getImageUrl() ? "nonebackground" : "opacity-50"); ?>">
                        <?php if($news->getImageUrl()): ?>
                            <img class="thumbnail" src="<?php echo $view['assets']->getUrl('media/assets/Blog/thumbnail/'.$news->getImageUrl()); ?>" alt="<?php echo $news->getTitle(); ?>">
                        <?php endif; ?>
                    </div>
                </div>
                <div class="large-10 columns">
                    <p><strong><?php echo $view['translator']->trans('blogNew.form.titleTitle'); ?>:</strong>
                        <?php echo $news->getTitle(); ?></p>
                    <p><strong><?php echo $view['translator']->trans('blogNew.form.shortTitle'); ?>:</strong>
                    <?php echo $news->getShortcut(); ?></p>
                    <p><strong><?php echo $view['translator']->trans('blogNew.form.dateTitle'); ?>:</strong>
                        <?php if ($news->getDateOfPublication()): ?>
                            <?php echo $news->getDateOfPublication()->format('Y-m-d'); ?>
                        <?php endif; ?>
                    </p>
                    <p><strong><?php echo $view['translator']->trans('blogNew.form.movieTitle'); ?>:</strong>
                    <?php echo $news->getMovie(); ?></p>
                    <p><strong><?php echo $view['translator']->trans('blogNew.form.catTitle'); ?>:</strong>
                        <?php foreach ($news->getCategories() as $category): ?>
                            <span class="info label secondary showNewsButton"><?php echo $category->getName(); ?></span>
                        <?php endforeach; ?>
                    </p>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('blogNew.form.textTitle'); ?>:</strong></p>
                </div>
                <div class="large-10 columns">
                    <div class="callout"><?php echo $news->getContent(); ?></div>
                    <?php if ($view['security']->isGranted('ROLE_BLOG_EDIT')): ?>
                        <a href="<?php echo $view['router']->path('wi_admin_blog_edit', array('id' => $news->getId())); ?>" class="button" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                            <i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="columns">
                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_blog_index'); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <div class="box collapsed-box">
    <div class="box-header bg-transparent">
        <div class="pull-right box-tools">
            <span class="box-btn" data-toggle="configShowNewsSEO-dropdown">
                    <i class="icon-cog-5"></i>
                </span>
            <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configShowNewsSEO-dropdown" data-dropdown data-close-on-click="true">
                <ul class="no-bullet">
                    <li>
                        <?php if ($view['security']->isGranted('ROLE_BLOG_EDIT')): ?>
                            <a href="<?php echo $view['router']->path('wi_admin_blog_edit', array('id' => $news->getId())); ?>" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                                <span><i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?></span>
                            </a>
                        <?php endif; ?>
                    </li>
                </ul>
            </div>
            <span>
                <i class="icon-up-open" data-widget="collapse"></i>
            </span>
        </div>
        <h3 class="box-title" data-widget="collapse"><i class="icon-chart-bar-2"></i>
            <span>
                <?php echo $view['translator']->trans('blogShow.seosem'); ?>
            </span>
        </h3>
    </div>
    <div class="box-body " style="display: none;">
        <div class="row">
            <div class="large-2 columns"></div>
            <div class="large-10 columns">
                <p><strong><?php echo $view['translator']->trans('blogNew.form.titleMetaTitle'); ?>:</strong>
                    <?php echo $view['front']->getMetaArrayValues($news)['title']; ?>
                </p>
                <p><strong><?php echo $view['translator']->trans('blogNew.form.titleMetaDescription'); ?>:</strong>
                    <?php echo $view['front']->getMetaArrayValues($news)['description']; ?>
                </p>
                <p><strong><?php echo $view['translator']->trans('blogNew.form.titleMetaKeywords'); ?>:</strong>
                    <?php echo $view['front']->getMetaArrayValues($news)['keywords']; ?>
                </p>
                <p><strong><?php echo $view['translator']->trans('blogNew.form.titleMetaCanonical'); ?>:</strong>
                    <?php echo $view['front']->getMetaArrayValues($news)['canonical']; ?>
                </p>
                <p><strong><?php echo $view['translator']->trans('blogNew.form.titleMetaImage'); ?>:</strong>
                    <?php echo $view['front']->getMetaArrayValues($news)['image']; ?>
                </p>
            </div>
        </div>
    </div>
</div>

<?php if ($news->getEnableDownload()): ?>
    <div class="box collapsed-box">
        <div class="box-header bg-transparent">
            <div class="pull-right box-tools">
                <?php if ($view['security']->isGranted('ROLE_FILE_EDIT')): ?>
                <span class="box-btn" data-toggle="dropdown-files"><i class="icon-cog-5"></i></span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="dropdown-files" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <li><a href="<?php echo $view['router']->path('wi_admin_download_file_new', ['news_id' => $news->getId()]); ?>" title="<?php echo $view['translator']->trans('file.action.add'); ?>"><span><i class="icon-doc-new"></i> <?php echo $view['translator']->trans('file.action.add'); ?></span></a></li>
                    </ul>
                </div>
                <?php endif; ?>

                <span><i class="icon-up-open collapseExpand" data-widget="collapse"></i></span>
            </div>
            <h3 class="box-title" data-widget="collapse"><i class="icon-download"></i><span><?php echo $view['translator']->trans('newsShow.fileList'); ?></span></h3>
        </div>
        <div class="box-body " style="display: none;">
            <div class="row">
                <div class="columns tableResp">
                    <?php if (count($files) > 0): ?>
                        <table id="file-list" class="display" style="width:100%;">
                            <thead>
                                <tr>
                                    <th><?php echo $view['translator']->trans('file.list.table.id'); ?></th>
                                    <th><?php echo $view['translator']->trans('file.list.table.title'); ?></th>
                                    <th><?php echo $view['translator']->trans('file.list.table.ext'); ?></th>
                                    <th><?php echo $view['translator']->trans('file.list.table.size'); ?></th>
                                    <th><?php echo $view['translator']->trans('file.list.table.downloadCount'); ?></th>
                                    <th><?php echo $view['translator']->trans('file.list.table.categories'); ?></th>
                                    <th><?php echo $view['translator']->trans('file.list.table.dateCreated'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($files as $file): ?>
                                <tr>
                                    <td><?php echo $file->getId(); ?></td>
                                    <td>
                                        <a href="<?php echo $view['router']->path('wi_admin_download_file_show', ['id' => $file->getId()]); ?>"><?php echo $file->getTitle(); ?></a>
                                        <div class="buttonItemsBox">
                                            <div class="buttonsItems">
                                                <a href="<?php echo $view['router']->path('wi_admin_download_file_show', ['id' => $file->getId()]); ?>"><i class="icon-eye-1"></i><?php echo $view['translator']->trans('Table.showButton'); ?></a>
                                                <?php if ($view['security']->isGranted('ROLE_FILE_EDIT')): ?>
                                                     / <a href="<?php echo $view['router']->path('wi_admin_download_file_edit', ['id' => $file->getId()]); ?>"><i class="icon-edit-1"></i><?php echo $view['translator']->trans('Table.editButton'); ?></a>
                                                     / <a href="<?php echo $view['router']->path('wi_admin_download_file_delete', ['id' => $file->getId()]); ?>"><i class="icon-cancel-circled-outline"></i><?php echo $view['translator']->trans('Table.deleteButton'); ?></a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </td>
                                    <td><?php echo $file->getExt(); ?></td>
                                    <td><?php echo $view['front']->formatBytes($file->getSize()); ?></td>
                                    <td><?php echo $file->getDownloadCount(); ?></td>
                                    <td>
                                        <?php foreach ($file->getCategories() as $category): ?>
                                            <span class="label info secondary tiny category-label"><?php echo $category->getName(); ?></span>
                                        <?php endforeach ?>
                                    </td>
                                    <td><?php echo $file->getDateCreated()->format('H:i:s d.m.Y'); ?></td>
                                </tr>
                            <?php endforeach ?>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <div class="callout primary"><?php echo $view['translator']->trans('no_data'); ?></div>
                    <?php endif ?>
                </div>
            </div>
            <div class="row">
                <div class="columns">
                    <div id="uploader" class="file-new">Your browser doesn't have HTML5 support.</div>
                </div>
            </div>
        </div>
    </div>
<?php endif ?>

<?php /* Modals */ ?>
<?php echo $view->render('WiAdminNewsBundle:Components:save_as_newsletter_message_modal.html.php', [
    'campaigns' => $campaigns,
    'news' => $news,
]); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/news.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/plupload.full.min.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/i18n/'.$view['request']->getLocale().'.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/jquery.plupload.queue/jquery.plupload.queue.min.js') ?>"></script>
<script>
$(function () {
    var max_file_count = 1;

    var uploader = $('#uploader').pluploadQueue({
        runtimes: 'html5,html4',
        url: Routing.generate('wi_admin_download_file_upload'),
        max_file_count: max_file_count,
        chunk_size: '200kb',
        max_retries: 3,
        dragdrop: true,
        multi_selection: false,

        init: {
            FilesAdded: function(up, files) {
                if (up.files.length > max_file_count) {
                    while (up.files.length> max_file_count) {
                        up.removeFile(up.files[max_file_count]);
                    }

                    alert('Max ' + max_file_count + ' files.');
                }
            },
            FileUploaded: function(up, file, info) {
                var filename = JSON.parse(info.response).filename;
                var size = file.origSize;

                $.ajax({
                    url: Routing.generate('wi_admin_download_file_ajax_file_save'),
                    method: 'POST',
                    data: {
                        file: {
                            systemName: filename,
                            title: filename,
                            size: size,
                        },
                        news_id: <?php echo $news->getId(); ?>,
                    },
                    dataType: 'JSON',
                    success: function(response) {
                        window.location.replace(Routing.generate('wi_admin_download_file_edit', {'id': response.id, 'news_id': <?php echo $news->getId(); ?>}));
                    }
                });
            }
        }
    });
});
</script>
<?php $view['slots']->stop() ?>
