<?php

namespace Wi\Admin\NewsBundle\Repository;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\EntityRepository;

/**
 * CategoryRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class CategoryRepository extends EntityRepository
{
    /**
     * Liczba wszystkich aktywnych kategorii.
     *
     * @return int
     */
    public function countActive($type)
    {
        $qb = $this->createQueryBuilder('c');

        return (int) $qb
            ->select($qb->expr()->count('c'))
            ->where('c.status = :status')
            ->andWhere('c.type = :type')
            ->setParameters([
                'status' => 'A',
                'type' => $type,
            ])
            ->getQuery()
            ->getSingleScalarResult()
        ;
    }

    /**
     * Pobiera wszystkie aktywne kategorie, dla podanego typu.
     *
     * @return array List of entities
     */
    public function findAllActiveWithoutParent($type)
    {
        return new ArrayCollection(
            $this->createQueryBuilder('c')
                ->addSelect('cc')
                ->leftJoin('c.children', 'cc')
                ->where('c.status = :status')
                ->andWhere('c.parent IS NULL')
                ->andWhere('c.dateDeleted IS NULL')
                ->andWhere('c.type = :type')
                ->setParameters([
                    'status' => 'A',
                    'type' => $type,
                ])
                ->orderBy('c.orderNr', 'ASC')
                ->addOrderBy('c.name', 'ASC')
                ->getQuery()
                ->getResult()
            )
        ;
    }

    /**
     * Pobiera grupy stron wraz ze stronami dla generowania pliku sitemap.
     *
     * @return array
     */
    public function findForSitemap()
    {
        return $this->createQueryBuilder('c')
            ->addSelect('n')
            ->innerJoin('c.news', 'n')
            ->where('n.status = :status')
            ->andWhere('c.status = :status')
            ->andWhere('c.dateDeleted IS NULL')
            ->andWhere('n.dateDeleted IS NULL')
            ->setParameters([
                'status' => 'A',
            ])
            ->orderBy('c.id', 'ASC')
            ->addOrderBy('n.dateOfPublication', 'DESC')
            ->getQuery()
            ->getResult()
        ;
    }
}
