<?php

namespace Wi\Admin\NewsBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\NewsBundle\Entity\NewsImage;

class NewsImageType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('orderNr', HiddenType::class, [])
            ->add('name', HiddenType::class, [])
            ->add('file', FileType::class, [
                'attr' => [
                    'accept' => '.jpg,.jpeg,.png',
                    'class' => 'InputFileHidden',
                ],
                'label' => false,
                'mapped' => false,
                'required' => true,
            ])
            ->add('crop_x', HiddenType::class, [
                'mapped' => false,
            ])
            ->add('crop_y', HiddenType::class, [
                'mapped' => false,
            ])
            ->add('crop_width', HiddenType::class, [
                'mapped' => false,
            ])
            ->add('crop_height', HiddenType::class, [
                'mapped' => false,
            ])
            ->add('cropSave', HiddenType::class, [
                'mapped' => false,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => NewsImage::class,
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'appbundle_photo';
    }
}
