<?php

namespace Wi\Admin\NewsBundle\EventListener\Entity;

use Doctrine\ORM\Event\LifecycleEventArgs;
use Wi\Admin\NewsBundle\Entity\News;

/**
 * News Listener.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class NewsListener
{
    /**
     * Metoda jest wykonywana przed usunięciem aktualności.
     *
     * @param  News                 $news
     * @param  LifecycleEventArgs   $event
     */
    public function preRemove(News $news, LifecycleEventArgs $event)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $event->getObjectManager();

        // Ustawienie statusu na usunięty.
        $news->setStatus('D');

        // Zapis.
        $em->persist($news);
        $em->flush();
    }
}
