<?php

namespace Wi\Admin\NewsBundle\EventListener\Entity;

use Doctrine\ORM\Event\LifecycleEventArgs;
use Wi\Admin\NewsBundle\Entity\Category;

/**
 * Category Listener.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class CategoryListener
{
    /**
     * Metoda jest wykonywana przed usunięciem kategorii aktualności.
     *
     * @param  Category             $category
     * @param  LifecycleEventArgs   $event
     */
    public function preRemove(Category $category, LifecycleEventArgs $event)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $event->getObjectManager();

        // Ustawienie statusu na usunięty.
        $category->setStatus('D');

        // Zapis.
        $em->persist($category);
        $em->flush();
    }
}
