<?php

namespace Wi\Admin\NewsBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Wi\Admin\NewsBundle\Entity\Category;

/**
 * Załadowanie grup stron do bazy danych.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LoadCategoryData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritdoc}
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->getData() as $data) {
            $category = $this->getCategory($data);
            $this->addReference('nb-category-'.$data['id'], $category);

            // Przygotowanie do zapisu.
            $manager->persist($category);

            // Wymuszenie podania ID.
            $metadata = $manager->getClassMetaData(get_class($category));
            $metadata->setIdGeneratorType(\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_NONE);
        }

        // Zapis.
        $manager->flush();
    }

    /**
     * {@inheritdoc}
     */
    public function getOrder()
    {
        return 11;
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Tablica danych.
     *
     * @return mixed[]
     */
    private function getData()
    {
        return [
            [
                'id' => 1,
                'parent' => null,
                'orderNr' => 1,
                'name' => 'Aktualności',
                'type' => Category::TYPE_NEWS,
            ],
            [
                'id' => 2,
                'parent' => null,
                'orderNr' => 1,
                'name' => 'Blog',
                'type' => Category::TYPE_BLOG,
            ],
        ];
    }

    /**
     * Tworzy nowy obiekt na podstawie przekazanej tablicy danych.
     *
     * @param array $data
     * @return \Wi\Admin\NewsBundle\Entity\Category
     */
    private function getCategory(array $data)
    {
        return (new Category())
            ->setId($data['id'])
            ->setParent((! is_null($data['parent']) ? $this->getReference('nb-category-' . $data['parent']) : null))
            ->setOrderNr($data['orderNr'])
            ->setName($data['name'])
            ->setType($data['type'])
        ;
    }
}
