<?php

namespace Wi\Admin\MenuBundle\Repository;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\EntityRepository;

/**
 * LocationRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LocationRepository extends EntityRepository
{
    /**
     * Pobiera wszystkie główne, aktywne grupy stron posortowane
     * wg kolejności i nazwy.
     *
     * @return  ArrayCollection
     */
    public function findAllActive()
    {
        // Utworzenie QueryBuilder'a.
        $qb = $this->createQueryBuilder('l')
            ->where('l.status = :status')
            ->andWhere('l.dateDeleted IS NULL')
        ;

        // Ustawienie parametrów dla zapytania.
        $params = [
            'status' => 'A',
        ];

        return new ArrayCollection(
            $qb
                ->setParameters($params)
                ->OrderBy('l.id', 'ASC')
                ->getQuery()
                ->getResult()
        );
    }
}
