<?php

namespace Wi\Admin\MenuBundle\Repository;

use Doctrine\ORM\EntityRepository;
use Wi\Admin\MenuBundle\Entity\ItemMenu;

/**
 * ItemMenuRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ItemMenuRepository extends EntityRepository
{
    /**
     * Pobiera wszystkie główne, aktywne pozycje menu posortowane
     * wg kolejności i nazwy.
     *
     * @param int $location
     * @return array
     */
    public function findAllActiveWithoutParent($location = null)
    {
        // Utworzenie QueryBuilder'a.
        $qb = $this->createQueryBuilder('m')
            ->where('m.status = :status')
            ->andWhere('m.dateDeleted IS NULL')
            ->andWhere('m.parent IS NULL')
        ;

        // Ustawienie parametrów dla zapytania.
        $params = [
            'status' => 'A',
        ];

        // Jeżeli jest podana lokalizacja menu.
        if ($location) {
            $params['location'] = $location;
            $qb->andWhere('m.location = :location');
        }

        return $qb
            ->setParameters($params)
            ->orderBy('m.orderNr', 'ASC')
            ->addOrderBy('m.name', 'ASC')
            ->getQuery()
            ->getResult()
        ;
    }

    /**
     * Pobiera wszystkie główne, aktywne pozycje menu posortowane
     * wg kolejności i nazwy.
     *
     * @param int $parent
     * @return array
     */
    public function findAllActiveChildren($parent)
    {
        // Utworzenie QueryBuilder'a.
        $qb = $this->createQueryBuilder('m')
            ->where('m.status = :status')
            ->andWhere('m.dateDeleted IS NULL')
            ->andWhere('m.parent = :parent')
        ;

        // Jeżeli jest podana lokalizacja menu.
        $params = [
            'parent' => $parent,
            'status' => 'A',
        ];

        return $qb
            ->setParameters($params)
            ->orderBy('m.orderNr', 'ASC')
            ->addOrderBy('m.name', 'ASC')
            ->getQuery()
            ->getResult()
        ;
    }

    /**
     * Pobiera największą wartość kolejności elementów i zwiększa ją o 1.
     *
     * @param ItemMenu $item
     * @return int
     */
    public function getLastOrderIncrement(ItemMenu $item) : int
    {
        $result = $this->createQueryBuilder('i')
            ->select('i.orderNr')
            ->where('i.location = :location')
            ->setParameters([
                'location' => $item->getLocation(),
            ])
            ->orderBy('i.orderNr', 'DESC')
            ->setMaxResults(1)
            ->getQuery()
            ->getOneOrNullResult()
        ;

        if (! $result) {
            return 1;
        }

        return current($result) + 1;
    }
}
