<?php

namespace Wi\Admin\MenuBundle\Form;

use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\MenuBundle\Entity\ItemMenu;
use Wi\Admin\MenuBundle\Entity\Location;
use Wi\Admin\MenuBundle\Entity\ItemType;
use Wi\Admin\MenuBundle\Entity\ItemModule;

class ItemMenuType extends AbstractType
{

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class, [
                'attr' => [
                    'maxlength' => 256,
                    'placeholder' => 'menuNew.form.name',
                ],
                'label' => 'menuNew.form.nameLabel',
                'required' => true,
            ])
            ->add('title', TextType::class, [
                'attr' => [
                    'maxlength' => 256,
                    'placeholder' => 'menuNew.form.title',
                ],
                'label' => 'menuNew.form.titleLabel',
                'required' => false,
            ])
            ->add('url', TextType::class, [
                'attr' => [
                    'class' => 'urlVal link-generator',
                    'maxlength' => 512,
                    'placeholder' => 'menuNew.form.url',
                ],
                'label' => 'menuNew.form.urlLabel',
                'required' => false,
            ])
            ->add('external', null, [
                'attr' => [
                    'class' => 'ifExternal',
                    'readonly' => 'readonly',
                ],
                'label' => 'menuNew.form.external',
            ])
            ->add('orderNr', null, [
                'attr' => [
                    'max' => 2147483646,
                    'maxlength' => 11,
                    'min' => -2147483646,
                ],
                'label' => 'menuNew.form.orderNr',
                'required' => false,
            ])
            ->add('status', ChoiceType::class, [
                'attr' => [
                    'class' => 'chosenSelect',
                ],
                'choices' => [
                    'Active' => ItemMenu::STATUS_ACTIVE,
                    'Inactive' => ItemMenu::STATUS_INACTIVE,
                ],
                'label' => 'menuNew.form.status',
                'required' => true,
            ])
            ->add('parent', EntityType::class, [
                'attr' => [
                    'class' => 'chosenSelect',
                ],
                'class' => 'WiAdminMenuBundle:ItemMenu',
                'choice_label' => 'name',
                'label' => 'menuNew.form.parent',
                'placeholder' => 'menuNew.form.parentDesc',
                'required' => false,
            ])
            ->add('location', EntityType::class, [
                'attr' => [
                    'class' => 'chosenSelect',
                ],
                'class' => 'WiAdminMenuBundle:Location',
                'choice_label' => 'name',
                'label' => 'menuNew.form.location',
                'required' => true,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => ItemMenu::class,
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_admin_menubundle_itemmenu';
    }
}
