<?php 

namespace Wi\Admin\MenuBundle\EventListener\Entity;

use Doctrine\ORM\Event\LifecycleEventArgs;
use Wi\Admin\MenuBundle\Entity\Location;

/**
 * Location Listener.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LocationListener
{
    /**
     * Metoda wykonywana jest przed usunięciem obiektu.
     *
     * @param   Location            $location
     * @param   LifecycleEventArgs  $event
     */
    public function preRemove(Location $location, LifecycleEventArgs $event)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $event->getObjectManager();

        // Ustawienie statusu na usunięty.
        $location->setStatus('D');

        // Zapis.
        $em->persist($location);
        $em->flush();
    }
}
