<?php

namespace Wi\Admin\MenuBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Wi\Admin\MenuBundle\Entity\ItemModule;
use Wi\Admin\MenuBundle\Entity\Location;

/**
 * ItemMenu
 *
 * @ORM\Table(
 *      name="menu_items",
 *      indexes={
 *          @ORM\Index(name="IX_Menu_Item_Parent_id", columns={"parent_id"}),
 *          @ORM\Index(name="IX_Menu_Item_Location_id", columns={"location_id"})
 *      }
 * )
 * @ORM\Entity(repositoryClass="Wi\Admin\MenuBundle\Repository\ItemMenuRepository")
 * @Gedmo\SoftDeleteable(fieldName = "dateDeleted")
 */
class ItemMenu
{
    /**
     * Status - aktywny.
     *
     * @const STATUS_ACTIVE
     */
    const STATUS_ACTIVE = 'A';

    /**
     * Status - usunięty.
     *
     * @const STATUS_DELETED
     */
    const STATUS_DELETED = 'D';

    /**
     * Status - nieaktywny.
     *
     * @const STATUS_INACTIVE
     */
    const STATUS_INACTIVE = 'N';

    // -------------------------------------------------------------------------

    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var \Wi\Admin\MenuBundle\Entity\ItemMenu
     *
     * @ORM\ManyToOne(targetEntity="Wi\Admin\MenuBundle\Entity\ItemMenu", inversedBy="children")
     * @ORM\JoinColumn(name="parent_id", referencedColumnName="id", nullable=true)
     */
    private $parent;

    /**
     * @var \Wi\Admin\MenuBundle\Entity\Location
     *
     * @ORM\ManyToOne(targetEntity="Wi\Admin\MenuBundle\Entity\Location", inversedBy="items")
     * @ORM\JoinColumn(name="location_id", referencedColumnName="id", nullable=false)
     */
    private $location;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255, nullable=true)
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="title", type="string", length=255, nullable=true)
     */
    private $title;

    /**
     * @var string
     *
     * @ORM\Column(name="url", type="string", length=512, nullable=true)
     */
    private $url;

    /**
     * @var bool
     *
     * @ORM\Column(name="external", type="boolean")
     */
    private $external;

    /**
     * @var int
     *
     * @ORM\Column(name="orderNr", type="integer", nullable=true)
     */
    private $orderNr;

    /**
     * @var string
     *
     * @ORM\Column(name="status", type="string", length=1, options={"default": "A", "fixed" = true})
     */
    private $status;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateDeleted", type="datetime", nullable=true)
     */
    private $dateDeleted;

    /**
     * @var ArrayCollection
     *
     * @ORM\OneToMany(targetEntity="Wi\Admin\MenuBundle\Entity\ItemMenu", mappedBy="parent", cascade={"persist"})
     * @ORM\OrderBy({"orderNr" = "ASC", "name" = "ASC"})
     */
    private $children;


    // ------------------------------------------------------------
    // Getters and setters methods.
    // ------------------------------------------------------------

    /**
     * Set id
     *
     * @param int $id
     * @return ItemMenu
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set url
     *
     * @param string $url
     * @return ItemMenu
     */
    public function setUrl($url)
    {
        $this->url = $url;

        return $this;
    }

    /**
     * Get url
     *
     * @return string
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * Set external
     *
     * @param boolean $external
     * @return ItemMenu
     */
    public function setExternal($external)
    {
        $this->external = $external;

        return $this;
    }

    /**
     * Get external
     *
     * @return bool
     */
    public function getExternal()
    {
        return $this->external;
    }

    /**
     * Set orderNr
     *
     * @param integer $orderNr
     * @return ItemMenu
     */
    public function setOrderNr($orderNr)
    {
        $this->orderNr = $orderNr;

        return $this;
    }

    /**
     * Get orderNr
     *
     * @return int
     */
    public function getOrderNr()
    {
        return $this->orderNr;
    }

    /**
     * Set status
     *
     * @param string $status
     * @return ItemMenu
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     * @return ItemMenu
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set dateDeleted
     *
     * @param \DateTime $dateDeleted
     * @return ItemMenu
     */
    public function setDateDeleted($dateDeleted)
    {
        $this->dateDeleted = $dateDeleted;

        return $this;
    }

    /**
     * Get dateDeleted
     *
     * @return \DateTime
     */
    public function getDateDeleted()
    {
        return $this->dateDeleted;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return ItemMenu
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set parent
     *
     * @param ItemMenu $parent
     * @return ItemMenu
     */
    public function setParent(ItemMenu $parent = null)
    {
        $this->parent = $parent;

        return $this;
    }

    /**
     * Get parent
     *
     * @return ItemMenu
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Set location
     *
     * @param Location $location
     * @return ItemMenu
     */
    public function setLocation(Location $location)
    {
        $this->location = $location;

        return $this;
    }

    /**
     * Get location
     *
     * @return Location
     */
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * Set title
     *
     * @param string $title
     * @return ItemMenu
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * Get title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Add child
     *
     * @param ItemMenu $child
     * @return ItemMenu
     */
    public function addChild(ItemMenu $child)
    {
        $this->children[] = $child;

        return $this;
    }

    /**
     * Remove child
     *
     * @param ItemMenu $child
     */
    public function removeChild(ItemMenu $child)
    {
        $this->children->removeElement($child);
    }

    /**
     * Get children
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getChildren()
    {
        return $this->children;
    }

    // ------------------------------------------------------------
    // Methods.
    // ------------------------------------------------------------

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->children = new ArrayCollection();
    }
}
