<?php

namespace Wi\Admin\MenuBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Doctrine\ORM\Mapping\ClassMetadata;
use Wi\Admin\MenuBundle\Entity\ItemModule;

/**
 * Załadowanie danych.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LoadItemModuleData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritdoc}
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->getData() as $data) {
            $itemModule = $this->getCategory($data);
            $this->addReference('mb-itemModule-'.$data['id'], $itemModule);

            // Przygotowanie do zapisu.
            $manager->persist($itemModule);

            // Wymuszenie podania ID.
            $metadata = $manager->getClassMetaData(get_class($itemModule));
            $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        }

        // Zapis.
        $manager->flush();
    }

    /**
     * {@inheritdoc}
     */
    public function getOrder()
    {
        return 43;
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Tablica danych.
     *
     * @return mixed[]
     */
    private function getData()
    {
        return [
            [
                'id' => 1,
                'name' => 'Strona główna',
                'route' => 'homepage',
            ],
            [
                'id' => 2,
                'name' => 'Strona',
                'route' => 'wi_front_page_index',
            ],
            [
                'id' => 3,
                'name' => 'Aktualności',
                'route' => 'wi_front_news_by_category_index',
            ],
            [
                'id' => 4,
                'name' => 'Blog',
                'route' => 'wi_front_news_by_category_index',
            ],
            [
                'id' => 5,
                'name' => 'Moje linki',
                'route' => 'wi_front_link_index',
            ],
            [
                'id' => 6,
                'name' => 'Formularz kontaktowy',
                'route' => 'wi_front_contact_index',
            ],
        ];
    }

    /**
     * Tworzy nowy obiekt na podstawie przekazanej tablicy danych.
     *
     * @param array $data
     * @return \Wi\Admin\NewsBundle\Entity\Category
     */
    private function getCategory(array $data)
    {
        return (new ItemModule())
            ->setId($data['id'])
            ->setName($data['name'])
            ->setRoute($data['route'])
        ;
    }
}
