<?php

namespace Wi\Admin\LinkBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\LinkBundle\Entity\Link;

/**
 * Link Type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LinkType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('url', TextType::class, [
                'attr' => [
                    'class' => 'input-group-field',
                    'placeholder' => 'link.form.url',
                ],
                'label' => false,
                'required' => true,
                'translation_domain' => 'link',
            ])
            ->add('utmEnable', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input new',
                ],
                'required' => false,
                'translation_domain' => false,
            ])
            ->add('utmSource', TextType::class, [
                'attr' => [
                    'class' => 'input-group-field utm-preview',
                ],
                'label' => 'link.form.utmSource',
                'required' => false,
                'translation_domain' => 'link',
                'translation_domain' => 'link',
            ])
            ->add('utmMedium', TextType::class, [
                'attr' => [
                    'class' => 'input-group-field utm-preview',
                ],
                'label' => 'link.form.utmMedium',
                'required' => false,
                'translation_domain' => 'link',
            ])
            ->add('utmName', TextType::class, [
                'attr' => [
                    'class' => 'input-group-field utm-preview',
                ],
                'label' => 'link.form.utmName',
                'required' => false,
                'translation_domain' => 'link',
            ])
            ->add('utmTerm', TextType::class, [
                'attr' => [
                    'class' => 'input-group-field utm-preview',
                ],
                'label' => 'link.form.utmTerm',
                'required' => false,
                'translation_domain' => 'link',
            ])
            ->add('utmContent', TextType::class, [
                'attr' => [
                    'class' => 'input-group-field utm-preview',
                ],
                'label' => 'link.form.utmContent',
                'required' => false,
                'translation_domain' => 'link',
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Link::class,
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_admin_linkbundle_link';
    }
}
