<?php

namespace Wi\Admin\LinkBundle\EventListener\Entity;

use Doctrine\ORM\Event\LifecycleEventArgs;
use Wi\Admin\LinkBundle\Entity\Link;

/**
 * Link Listener.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LinkListener
{
    /**
     * Funkcja wykonuje się przed usunięciem rekordu.
     *
     * @param  Link $link
     * @param  LifecycleEventArgs $event
     */
    public function preRemove(Link $link, LifecycleEventArgs $event)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $event->getObjectManager();

        // Ustawienie statusu na usunięty.
        $link->setStatus('D');

        // Zapis.
        $em->persist($link);
        $em->flush();
    }
}
