<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_faq_question_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.faqQuestion.questionList')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css') ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css') ?>"  rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/faq.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"  rel="stylesheet" type="text/css" />
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_faq_question_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.faqQuestion.questionList'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-help-circled"></i><?php echo $view['translator']->trans('faqQuestion.listTitle'); ?> - <?php echo $view['translator']->trans('faqQuestionList.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('faqQuestionList.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
    <?php
    $addNewFAQParamsLink = [];

    if ($view['request']->getParameter('category_id')) {
        $addNewFAQParamsLink['category_id'] = $view['request']->getParameter('category_id');
    }
    ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
            <span class="box-btn" data-toggle="configCategory-dropdown">
                 <i class="icon-cog-5"></i>
            </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configCategory-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <?php if ($view['security']->isGranted('ROLE_FAQ_EDIT')): ?>
                            <li>
                                <a href="<?php echo $view['router']->path('wi_admin_faq_category_new') ?>"  title="<?php echo $view['translator']->trans('faqQuestionList.addNewCategory'); ?>">
                                    <span><i class="icon-folder-add"></i> <?php echo $view['translator']->trans('faqQuestionList.addNewCategory'); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if ($view['request']->getParameter('category_id')): ?>
                            <li>
                                <a href="<?php echo $view['router']->path('wi_admin_faq_category_show', ['id' => $view['request']->getParameter('category_id')]) ?>" title="<?php echo $view['translator']->trans('faqQuestionList.editCategory'); ?>">
                                    <span><i class="icon-folder-open-empty"></i> <?php echo $view['translator']->trans('faqQuestionList.editCategory'); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <li>
                            <a href="<?php echo $view['router']->path('wi_admin_faq_category_index') ?>" title="<?php echo $view['translator']->trans('faqQuestionList.menageCategory'); ?>">
                                <span><i class="icon-folder-2"></i> <?php echo $view['translator']->trans('faqQuestionList.menageCategory'); ?></span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <h3 class="box-title"><i class="icon-filter"></i>
                <span><?php echo $view['translator']->trans('newsList.selectCategory'); ?>:</span>
            </h3>
            <form method="get" id="selectCategoryForm">
                <?php
                $knp_params = $questions->getParams();

                if (isset($knp_params['category_id'])) {
                    unset($knp_params['category_id']);
                }
                ?>
                <?php foreach ($knp_params as $param => $value): ?>
                    <input type="hidden" name="<?php echo $param; ?>" value="<?php echo $value; ?>">
                <?php endforeach; ?>
                <label>
                    <select name="category_id" class="selectCategory">
                        <option value=""><?php echo $view['translator']->trans('faqQuestionList.selectCategoryAll'); ?></option>
                        <?php foreach ($categories as $category): ?>
                            <option value="<?php echo $category->getId(); ?>" <?php echo $category->getId() != $view['request']->getParameter('category_id') ? '' : 'selected'; ?>><?php echo $category->getName(); ?></option>
                        <?php endforeach; ?>
                    </select>
                </label>
            </form>
            <?php if(! is_null($view['request']->getParameter('category_id'))): ?>
                <a class="clearFilter" href="<?php echo $view['router']->path('wi_admin_faq_question_index') ?>" title="<?php echo $view['translator']->trans('faqQuestionList.clearFilter'); ?>"><i class="icon-cancel"></i></a>
            <?php endif; ?>
        </div>
    </div>
    <div class="box">
       <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
            <span class="box-btn" data-toggle="configNews-dropdown">
                    <i class="icon-cog-5"></i>
            </span>
            <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configNews-dropdown" data-dropdown data-close-on-click="true">
                <ul class="no-bullet">
                    <li>
                        <?php if ($view['security']->isGranted('ROLE_FAQ_EDIT')): ?>
                            <a href="<?php echo $view['router']->path('wi_admin_faq_question_new', $addNewFAQParamsLink) ?>" title="<?php echo $view['translator']->trans('faqQuestionList.add'); ?>">
                                <span><i class="icon-doc-add"></i> <?php echo $view['translator']->trans('faqQuestionList.add'); ?></span>
                            </a>
                        <?php endif; ?>
                    </li>
                </ul>
            </div>
            </div>
            <h3 class="box-title"><i class="icon-help-circled"></i>
                <span><?php echo $view['translator']->trans('faqQuestionList.listSubTitle'); ?></span>
            </h3>
            <div class="ListQuestionSearch">
                <?php echo $view->render('KnpPaginatorBundle/Pagination/search.html.php', [
                    'knp_pagination' => $questions,
                ]); ?>
            </div>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="medium-6 columns ">
                    <?php if ($view['security']->isGranted('ROLE_FAQ_EDIT')): ?>
                        <a href="<?php echo $view['router']->path('wi_admin_faq_question_new', $addNewFAQParamsLink) ?>" title="<?php echo $view['translator']->trans('faqQuestionList.add'); ?>" class="button primary questionListNewTop">
                            <i class="icon-doc-add"></i> <?php echo $view['translator']->trans('faqQuestionList.add'); ?>
                        </a>
                    <?php endif; ?>
                </div>
                <div class="columns tableResp">
                    <table id="questionList" class="display" style="width:100%">
                        <thead>
                        <tr>
                            <th><?php echo $view['translator']->trans('faqQuestionList.table.question'); ?></th>
                            <th><?php echo $view['translator']->trans('faqQuestionList.table.short'); ?></th>
                            <th><?php echo $view['translator']->trans('faqQuestionList.table.category'); ?></th>
                            <th><?php echo $view['translator']->trans('faqQuestionList.table.date'); ?></th>
                            <th><?php echo $view['translator']->trans('faqQuestionList.table.orderNr'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($questions->getItems() as $key => $question): ?>
                            <tr>
                                <td><?php echo $question->getQuestion(); ?></td>
                                <td><a href="<?php echo $view['router']->path('wi_admin_faq_question_show', ['id' => $question->getId()]); ?>"><b><?php echo ($question->getShortcut() ? substr(trim(strip_tags($question->getShortcut())),0,200) : substr(trim(strip_tags($question->getAnswer())),0,200)); ?> <?php echo (strlen(trim(strip_tags($question->getShortcut())))>200 ? "..." : ""); ?></b></a>
                                    <div class="buttonItemsBox">
                                        <div class="buttonsItems">
                                            <a href="<?php echo $view['router']->path('wi_admin_faq_question_show', ['id' => $question->getId()]); ?>" class=""><i class="icon-eye-1"></i><?php echo $view['translator']->trans('Table.showButton'); ?></a> /
                                            <?php if ($view['security']->isGranted('ROLE_FAQ_EDIT')): ?>
                                                <a href="<?php echo $view['router']->path('wi_admin_faq_question_edit', ['id' => $question->getId()]); ?>" class=""><i class="icon-edit-1"></i><?php echo $view['translator']->trans('Table.editButton'); ?></a> /
                                            <?php endif; ?>
                                            <?php if ($view['security']->isGranted('ROLE_FAQ_EDIT')): ?>
                                                <a href="<?php echo $view['router']->path('wi_admin_faq_question_delete', ['id' => $question->getId()]); ?>" class=""><i class="icon-cancel-circled-outline"></i><?php echo $view['translator']->trans('Table.deleteButton'); ?></a>
                                            <?php endif; ?>
                                        </div>
                                    </div></td>
                                <td class="showCategoryFAQ">
                                    <div class="tiny button-group">
                                        <?php foreach ($question->getCategories() as $category): ?>
                                            <span class="info label secondary showFAQButton"><?php echo $category->getName(); ?></span>
                                        <?php endforeach; ?>
                                    </div>
                                </td>
                                <td>
                                    <?php if ($question->getDateCreated()): ?>
                                        <?php echo $question->getDateCreated()->format('Y-m-d H:i:s'); ?>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="OrderNrForm">
                                    <?php if (isset($questions->getItems()[$key - 1])): ?>
                                        <div><a href="<?php echo $view['router']->path('wi_admin_faq_question_update_order', ['id' => $question->getId(), 'sort_dir' => 'up']); ?>" class="button secondary tiny"><i class="icon-up-big margin-center"></i></a></div>
                                    <?php else: ?>
                                        <div><span class="button disabled secondary tiny"><i class="icon-up-big margin-center"></i></span></div>
                                    <?php endif ?>
                                    <?php if (isset($questions->getItems()[$key + 1])): ?>
                                        <div><a href="<?php echo $view['router']->path('wi_admin_faq_question_update_order', ['id' => $question->getId(), 'sort_dir' => 'down']); ?>" class="button secondary tiny"><i class="icon-down-big margin-center"></i></a></div>
                                    <?php else: ?>
                                        <div><span class="button disabled secondary tiny"><i class="icon-down-big margin-center"></i></span></div>
                                    <?php endif ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="row">
                <div class="medium-6 columns">
                    <?php if ($view['security']->isGranted('ROLE_FAQ_EDIT')): ?>
                        <a href="<?php echo $view['router']->path('wi_admin_faq_question_new', $addNewFAQParamsLink) ?>" title="<?php echo $view['translator']->trans('faqQuestionList.add'); ?>" class="button primary questionListNew">
                            <i class="icon-doc-add"></i> <?php echo $view['translator']->trans('faqQuestionList.add'); ?>
                        </a>
                    <?php endif; ?>
                </div>
                <div class="medium-6 columns paginationBox">
                    <?php echo $view->render('KnpPaginatorBundle/Pagination/per_page.html.php', [
                        'knp_pagination' => $questions,
                    ]); ?>

                    <?php echo $view['knp_pagination']->render($questions); ?>
                </div>
            </div>
        </div>
    </div>
    <script>
        var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
    </script>
<?php $view['slots']->stop() ?>


<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/faq.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>

