<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_faq_question_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.category.catNew')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.min.css') ?>" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/faq.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_faq_question_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.faqQuestion.faq'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_faq_category_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.category.catList'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_faq_category_new'); ?>"><?php echo $view['translator']->trans('breadcrumbs.category.catAdd'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-help-circled"></i><?php echo $view['translator']->trans('faqQuestion.listTitle'); ?> - <?php echo $view['translator']->trans('catNew.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('catNew.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title"><i class="icon-folder-add"></i>
                <span><?php echo $view['translator']->trans('catNew.listSubTitle'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('catNew.formTitle'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('catNew.formDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <?php if ($view['form']->errors($form)): ?>
                        <div class="alert callout small">
                            <?php echo $view['form']->errors($form); ?>
                        </div>
                    <?php endif; ?>
                    <?php echo $view['form']->start($form) ?>
                    <div class="row">
                        <div class="medium-12 large-6 columns end">
                            <?php echo $view['form']->label($form['name']) ?>
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['name']) ?>
                                </div>
                            <?php echo($view['form']->errors($form['name']) ? $view['form']->widget($form['name'], array('attr' => array('class' => 'callout alert'))) : $view['form']->widget($form['name'])) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="small-6 medium-4 large-2 columns end">
                            <?php echo $view['form']->label($form['orderNr']) ?>
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['orderNr']) ?>
                                </div>
                            <?php echo($view['form']->errors($form['orderNr']) ? $view['form']->widget($form['orderNr'], array('attr' => array('class' => 'callout alert'))) : $view['form']->widget($form['orderNr'])) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="medium-12 large-6 columns end">
                            <?php echo $view['form']->label($form['description']) ?>
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['description']) ?>
                                </div>
                            <?php echo($view['form']->errors($form['description']) ? $view['form']->widget($form['description'], array('attr' => array('class' => 'callout alert'))) : $view['form']->widget($form['description'])) ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                </div>
                <div class="large-10 columns">
                    <div class="wi-konatkt-form">
                        <button class="button" href="#" type="submit" value="<?php echo $view['translator']->trans('Form.create'); ?>">
                            <i class="icon-plus"></i> <?php echo $view['translator']->trans('Form.create'); ?>
                        </button>
                        <?php echo $view['form']->end($form) ?>
                        <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_faq_category_index'); ?>">
                            <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.jquery.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/faq.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop(); ?>
