<?php

namespace Wi\Admin\FAQBundle\Repository;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\EntityRepository;

/**
 * CategoryRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class CategoryRepository extends EntityRepository
{
    /**
     * Pobiera wszystkie aktywne kategorie.
     *
     * @return array List of entities
     */
    public function findAllActive()
    {
        return new ArrayCollection(
            $this->createQueryBuilder('c')
                ->where('c.status = :status')
                ->andWhere('c.dateDeleted IS NULL')
                ->setParameters([
                    'status' => 'A',
                ])
                ->orderBy('c.orderNr', 'ASC')
                ->addOrderBy('c.name', 'ASC')
                ->getQuery()
                ->getResult()
            )
        ;
    }
}
