<?php

namespace Wi\Admin\FAQBundle\Form;

use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Wi\Admin\FAQBundle\Entity\Question;

/**
 * Question Type
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class QuestionType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('question', TextType::class, [
                'attr' => [
                    'maxlength' => 256,
                    'placeholder' => 'faqQuestionNew.form.titleTitle',
                ],
            ])
            ->add('shortcut', TextareaType::class, [
                'attr' => [
                    'maxlength' => 512,
                    'placeholder' => 'faqQuestionNew.form.shortTitle',
                ],
                'required' => false,
            ])
            ->add('answer', TextareaType::class, [
                'attr' => [
                    'class' => 'tinyMCE',
                    'maxlength' => 65535,
                    'rows' => 10,
                ],
                'required' => false,
            ])
            ->add('dateOfPublication', DateTimeType::class, [
                'attr' => [
                    'class' => 'datePicker',
                ],
                'format' => 'dd-MM-yyyy',
                'required' => false,
                'widget' => 'single_text',
            ])
            ->add('metaTitle', TextType::class, [
                'attr' => [
                    'maxlength' => 256,
                    'placeholder' => 'faqQuestionNew.form.placeMetaTitle',
                ],
                'required' => false,
            ])
            ->add('metaDescription', TextareaType::class, [
                'attr' => [
                    'maxlength' => 512,
                    'placeholder' => 'faqQuestionNew.form.placeMetaDescription',
                ],
                'required' => false,
            ])
            ->add('metaCanonical', TextType::class, [
                'attr' => [
                    'maxlength' => 512,
                    'placeholder' => 'faqQuestionNew.form.placeMetaCanonical',
                ],
                'required' => false,
            ])

            ->add('categories', EntityType::class, [
                'attr' => [
                    'class' => 'chosenSelectCategory',
                ],
                'class' => 'WiAdminFAQBundle:Category',
                'choice_label' => 'name',
                'expanded' => false,
                'multiple' => true,
                'required' => false,
                'query_builder' => function (EntityRepository $er) {
                    return $er->createQueryBuilder('c')
                        ->orderBy('c.name', 'ASC')
                    ;
                },
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Question::class,
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_admin_faqbundle_question';
    }
}
