<?php

namespace Wi\Admin\FAQBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\FAQBundle\Entity\Category;

/**
 * Category Type.
 *
 * @author Maksymilian <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class CategoryType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class, [
                'attr' => [
                    'maxlength' => 45,
                ],
                'label' => 'categoryForm.name',
            ])
            ->add('orderNr', null, [
                'attr' => [
                    'max' => 2147483646,
                    'maxlength' => 11,
                    'min' => -2147483646,
                ],
                'label' => 'categoryForm.orderNr',
            ])
            ->add('description', TextareaType::class, [
                'attr' => [
                    'maxlength' => 65535,
                ],
                'label' => 'categoryForm.description',
                'required' => false,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Category::class,
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_admin_faqbundle_category';
    }
}
