<?php

namespace Wi\Admin\DownloadBundle\Utils;

use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Wi\Admin\CoreBundle\Utils\Upload as BaseUpload;

/**
 * Upload photos for News.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class Upload extends BaseUpload
{
    /**
     * Construct.
     *
     * @param ContainerInterface $container
     */
    public function __construct(ContainerInterface $container)
    {
        // Called to parent construct.
        parent::__construct($container);

        // Get config.
        $config = $container->get('config');

        // Set a directory.
        $this->dir = $this->container->getParameter('upload_dirs.files');
    }

    /**
     * Upload File. Return filename.
     *
     * @param UploadedFile
     * @param array
     * @return null|string
     */
    public function upload(UploadedFile $file, $params = [])
    {
        $filename = $this->getEnsureFilenameUnique(
            $this->dir,
            $this->prepareFilename(
                $file->getClientOriginalName(),
                $file->getClientOriginalExtension()
            )
        );
        $file = $file->move($this->dir, $filename);

        return $file->getFilename();
    }
}
