<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_download_file_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.file.index')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/download.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.cmsAdvanced'); ?></li>
<li><a href="<?php echo $view['router']->path('wi_admin_download_file_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.file.list'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<i class="icon-docs"></i><?php echo $view['translator']->trans('file.list.title'); ?> - <?php echo $view['translator']->trans('file.list.subtitle'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleDesc'); ?>
<?php echo $view['translator']->trans('file.list.desc'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <div class="pull-right box-tools">
            <span class="box-btn" data-toggle="dropdown"><i class="icon-cog-5"></i></span>
            <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="dropdown" data-dropdown data-close-on-click="true">
                <ul class="no-bullet">
                <?php if ($view['security']->isGranted('ROLE_FILE_EDIT')): ?>
                    <li><a href="<?php echo $view['router']->path('wi_admin_download_file_new'); ?>" title="<?php echo $view['translator']->trans('file.action.add'); ?>"><span><i class="icon-doc-new"></i> <?php echo $view['translator']->trans('file.action.add'); ?></span></a></li>
                    <li><a href="<?php echo $view['router']->path('wi_admin_download_file_category_index'); ?>" title="<?php echo $view['translator']->trans('file.categories.manage'); ?>"><span><i class="icon-folder-2"></i> <?php echo $view['translator']->trans('file.categories.manage'); ?></span></a></li>
                <?php endif ?>
                </ul>
            </div>
        </div>
        <h3 class="box-title"><i class="icon-docs"></i><span><?php echo $view['translator']->trans('file.list.list.subtitle'); ?></span></h3>
    </div>
    <div class="box-body " style="display: block;">
        <div class="row">
            <?php if ($view['security']->isGranted('ROLE_FILE_EDIT')): ?>
            <div class="columns">
                <a href="<?php echo $view['router']->path('wi_admin_download_file_new'); ?>" class="button primary" title="<?php echo $view['translator']->trans('file.action.add'); ?>"><span><i class="icon-doc-new"></i> <?php echo $view['translator']->trans('file.action.add'); ?></span></a>
            </div>
            <?php endif ?>

            <div class="columns tableResp">
                <table id="file-list" class="display" style="width:100%;">
                    <thead>
                        <tr>
                            <th><?php echo $view['translator']->trans('file.list.table.id'); ?></th>
                            <th><?php echo $view['translator']->trans('file.list.table.title'); ?></th>
                            <th><?php echo $view['translator']->trans('file.list.table.ext'); ?></th>
                            <th><?php echo $view['translator']->trans('file.list.table.size'); ?></th>
                            <th><?php echo $view['translator']->trans('file.list.table.downloadCount'); ?></th>
                            <th><?php echo $view['translator']->trans('file.list.table.categories'); ?></th>
                            <th><?php echo $view['translator']->trans('file.list.table.dateCreated'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($files as $file): ?>
                        <tr>
                            <td><?php echo $file->getId(); ?></td>
                            <td>
                                <a href="<?php echo $view['router']->path('wi_admin_download_file_show', ['id' => $file->getId()]); ?>"><?php echo $file->getTitle(); ?></a>
                                <div class="buttonItemsBox">
                                    <div class="buttonsItems">
                                        <a href="<?php echo $view['router']->path('wi_admin_download_file_show', ['id' => $file->getId()]); ?>"><i class="icon-eye-1"></i><?php echo $view['translator']->trans('Table.showButton'); ?></a>
                                        <?php if ($view['security']->isGranted('ROLE_FILE_EDIT')): ?>
                                             / <a href="<?php echo $view['router']->path('wi_admin_download_file_edit', ['id' => $file->getId()]); ?>"><i class="icon-edit-1"></i><?php echo $view['translator']->trans('Table.editButton'); ?></a>
                                             / <a href="<?php echo $view['router']->path('wi_admin_download_file_delete', ['id' => $file->getId()]); ?>"><i class="icon-cancel-circled-outline"></i><?php echo $view['translator']->trans('Table.deleteButton'); ?></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                            <td><?php echo $file->getExt(); ?></td>
                            <td><?php echo $view['front']->formatBytes($file->getSize()); ?></td>
                            <td><?php echo $file->getDownloadCount(); ?></td>
                            <td>
                                <?php foreach ($file->getCategories() as $category): ?>
                                    <span class="label info secondary tiny category-label"><?php echo $category->getName(); ?></span>
                                <?php endforeach ?>
                            </td>
                            <td><?php echo $file->getDateCreated()->format('H:i:s d.m.Y'); ?></td>
                        </tr>
                    <?php endforeach ?>
                    </tbody>
                </table>
            </div>

        </div>

        <div class="row">
            <div class="medium-6 columns">
            <?php if ($view['security']->isGranted('ROLE_FILE_EDIT')): ?>
                <a href="<?php echo $view['router']->path('wi_admin_download_file_new'); ?>" class="button primary" title="<?php echo $view['translator']->trans('file.action.add'); ?>"><span><i class="icon-doc-new"></i> <?php echo $view['translator']->trans('file.action.add'); ?></span></a>
            <?php endif ?>
            </div>

            <div class="medium-6 columns paginationBox">
                <?php echo $view->render('KnpPaginatorBundle/Pagination/per_page.html.php', [
                    'knp_pagination' => $files,
                ]); ?>

                <?php echo $view['knp_pagination']->render($files); ?>
            </div>
        </div>
    </div>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/download.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
