<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_download_file_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.file.categories.index')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.cmsAdvanced'); ?></li>
<li><a href="<?php echo $view['router']->path('wi_admin_download_file_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.file.list'); ?></a></li>
<li><a href="<?php echo $view['router']->path('wi_admin_download_file_category_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.file.categories.list'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<i class="icon-folder-2"></i><?php echo $view['translator']->trans('file.categories.list.title'); ?> - <?php echo $view['translator']->trans('file.categories.list.subtitle'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleDesc'); ?>
<?php echo $view['translator']->trans('file.categories.list.desc'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <div class="pull-right box-tools">
            <span class="box-btn" data-toggle="dropdown"><i class="icon-cog-5"></i></span>
            <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="dropdown" data-dropdown data-close-on-click="true">
                <ul class="no-bullet">
                <?php if ($view['security']->isGranted('ROLE_FILE_EDIT')): ?>
                    <li><a href="<?php echo $view['router']->path('wi_admin_download_file_category_new'); ?>" title="<?php echo $view['translator']->trans('file.categories.add'); ?>"><span><i class="icon-folder-add"></i> <?php echo $view['translator']->trans('file.categories.add'); ?></span></a></li>
                <?php endif ?>
                </ul>
            </div>
        </div>
        <h3 class="box-title"><i class="icon-folder-2"></i><span><?php echo $view['translator']->trans('file.categories.list.list.subtitle'); ?></span></h3>
    </div>
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="columns tableResp">
                <table id="file-category-list" class="display" style="width:100%;">
                    <thead>
                        <tr>
                            <th><?php echo $view['translator']->trans('file.categories.list.table.id'); ?></th>
                            <th><?php echo $view['translator']->trans('file.categories.list.table.name'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($categories as $category): ?>
                        <tr>
                            <td><?php echo $category->getId(); ?></td>
                            <td>
                                <a href="<?php echo $view['router']->path('wi_admin_download_file_category_show', ['id' => $category->getId()]); ?>"><?php echo $category->getName(); ?></a>
                                <div class="buttonItemsBox">
                                    <div class="buttonsItems">
                                        <a href="<?php echo $view['router']->path('wi_admin_download_file_category_show', ['id' => $category->getId()]); ?>"><i class="icon-eye-1"></i><?php echo $view['translator']->trans('Table.showButton'); ?></a>
                                        <?php if ($view['security']->isGranted('ROLE_FILE_EDIT')): ?>
                                             / <a href="<?php echo $view['router']->path('wi_admin_download_file_category_edit', ['id' => $category->getId()]); ?>"><i class="icon-edit-1"></i><?php echo $view['translator']->trans('Table.editButton'); ?></a>
                                             / <a href="<?php echo $view['router']->path('wi_admin_download_file_category_delete', ['id' => $category->getId()]); ?>"><i class="icon-cancel-circled-outline"></i><?php echo $view['translator']->trans('Table.deleteButton'); ?></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="row">
            <div class="large-2 columns"></div>
            <div class="large-10 columns">
                <div class="news-add-form">
                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_download_file_index'); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('file.categories.backToFiles'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/download.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
