<?php

namespace Wi\Admin\DownloadBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Wi\Admin\CoreBundle\Form\DeleteType;
use Wi\Admin\DownloadBundle\Entity\Category;
use Wi\Admin\DownloadBundle\Form\CategoryType;

/**
 * Category controller.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2018 WEBimpuls Sp. z o.o.
 */
class CategoryController extends Controller
{
    /**
     * Lista kategorii.
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();
        $categories = $em->getRepository('WiAdminDownloadBundle:Category')->findAll();

        return $this->render('WiAdminDownloadBundle:Category:index.html.php', [
            'categories' => $categories,
        ]);
    }

    /**
     * Nowa kategoria.
     *
     * @param Request $request
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function newAction(Request $request)
    {
        // Utworzenie nowego obiektu kategorii.
        $category = new Category();

        // Generowanie formularza.
        $form = $this->createForm(CategoryType::class, $category);
        $form->handleRequest($request);

        // Weryfikacja, czy formularz został przesłany i pomyślnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
            // Utworzenie instancji EntityManager-a.
            $em = $this->getDoctrine()->getManager();

            // Zapis.
            $em->persist($category);
            $em->flush();

            return $this->redirectToRoute('wi_admin_download_file_category_show', [
                'id' => $category->getId(),
            ]);
        }

        return $this->render('WiAdminDownloadBundle:Category:new.html.php', [
            'category' => $category,
            'form' => $form->createView(),
        ]);
    }

    /**
     * Szczegóły kategorii.
     *
     * @param Category $category
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function showAction(Category $category)
    {
        return $this->render('WiAdminDownloadBundle:Category:show.html.php', [
            'category' => $category,
        ]);
    }

    /**
     * Edycja kategorii.
     *
     * @param Request $request
     * @param Category $category
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function editAction(Request $request, Category $category)
    {
        // Generowanie formularza.
        $form = $this->createForm(CategoryType::class, $category);
        $form->handleRequest($request);

        // Weryfikacja, czy formularz został przesłany i pomyślnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
            // Utworzenie instancji EntityManager-a.
            $em = $this->getDoctrine()->getManager();

            // Zapis.
            $em->persist($category);
            $em->flush();

            return $this->redirectToRoute('wi_admin_download_file_category_show', [
                'id' => $category->getId(),
            ]);
        }

        return $this->render('WiAdminDownloadBundle:Category:edit.html.php', [
            'category' => $category,
            'form' => $form->createView(),
        ]);
    }

    /**
     * Usunięcie kategorii.
     *
     * @param Request $request
     * @param Category $category
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function deleteAction(Request $request, Category $category)
    {
        $form = $this->createForm(DeleteType::class);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            // Utworzenie instancji EntityManager-a.
            $em = $this->getDoctrine()->getManager();
            $em->remove($category);
            $em->flush();

            return $this->redirectToRoute('wi_admin_download_file_category_index');
        }

        return $this->render('WiAdminDownloadBundle:Category:delete.html.php', [
            'form' => $form->createView(),
            'category' => $category,
        ]);
    }
}
