<?php

namespace Wi\Admin\CoreBundle\Utils;

class Utils
{
    private static $requestStack;
    private static $requestContext;

    /**
     * Initialize static.
     */
    public static function init()
    {
        $container = $GLOBALS['kernel']->getContainer();

        if (! empty($container)) {
            self::$requestStack = $container->get('request_stack');
            self::$requestContext = $container->get('router')->getContext();
        }
    }

    /**
     * Adaptacja metody absolute_url() z Twig-a.
     *
     * @param string $path
     * @return string
     */
    public static function assetAbsoluteUrl($path)
    {
        if (false !== strpos($path, '://') || '//' === substr($path, 0, 2)) {
            return $path;
        }

        if (! $request = self::$requestStack->getMasterRequest()) {
            if (null !== self::$requestContext && '' !== $host = self::$requestContext->getHost()) {
                $scheme = self::$requestContext->getScheme();
                $port = '';

                if ('http' === $scheme && 80 != self::$requestContext->getHttpPort()) {
                    $port = ':'.self::$requestContext->getHttpPort();
                } elseif ('https' === $scheme && 443 != self::$requestContext->getHttpsPort()) {
                    $port = ':'.self::$requestContext->getHttpsPort();
                }

                if ('#' === $path[0]) {
                    $queryString = self::$requestContext->getQueryString();
                    $path = self::$requestContext->getPathInfo().($queryString ? '?'.$queryString : '').$path;
                } elseif ('?' === $path[0]) {
                    $path = self::$requestContext->getPathInfo().$path;
                }

                if ('/' !== $path[0]) {
                    $path = rtrim(self::$requestContext->getBaseUrl(), '/').'/'.$path;
                }

                return $scheme.'://'.$host.$port.$path;
            }

            return $path;
        }

        if ('#' === $path[0]) {
            $path = $request->getRequestUri().$path;
        } elseif ('?' === $path[0]) {
            $path = $request->getPathInfo().$path;
        }

        if (!$path || '/' !== $path[0]) {
            $prefix = '';
            $last = strlen($prefix) - 1;
            if ($last !== $pos = strrpos($prefix, '/')) {
                $prefix = substr($prefix, 0, $pos).'/';
            }

            return $request->getSchemeAndHttpHost().$request->getBasePath().$prefix.$path;
        }

        return $request->getSchemeAndHttpHost().$path;
    }
}

Utils::init();
