<?php

namespace Wi\Admin\CoreBundle\Twig\Extension;

use Symfony\Bridge\Twig\Extension\HttpFoundationExtension;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\Routing\RequestContext;

/**
 * Funkcje do e-maili dla Twig-a.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class MailerExtension extends \Twig_Extension
{
    private $httpFoundationExtension;
    private $masterRequest;

    /**
     * Constructor.
     *
     * @param HttpFoundationExtension $httpFoundationExtension
     * @param RequestStack $requestStack
     */
    public function __construct(HttpFoundationExtension $httpFoundationExtension, RequestStack $requestStack)
    {
        $this->httpFoundationExtension = $httpFoundationExtension;
        $this->masterRequest = $requestStack->getMasterRequest();
    }

    /**
     * {@inheritdoc}
     */
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction('embedImage', [$this, 'embedImage']),
        ];
    }

    /**
     * Osadzanie zdjęć w szablonach email.
     *
     * @param string $path
     * @param \Swift_Message $message
     * @return string
     */
    public function embedImage($path, $message)
    {
        if (! $this->issetMasterRequest()) {
            $path = ltrim($path, '/');
        }

        return $message->embed(\Swift_Image::fromPath($this->httpFoundationExtension->generateAbsoluteUrl($path)));
    }

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return 'app_mailer';
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    private function issetMasterRequest()
    {
        return (bool) $this->masterRequest;
    }
}
