<?php

namespace Wi\Admin\CoreBundle\Service;

use Wi\Admin\CoreBundle\Service\Config;

/**
 * Seo manager.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class Cookie
{
    /**
     * @var Config
     */
    private $config;

    /**
     * Constructor.
     *
     * @param Config $config
     */
    public function __construct(Config $config)
    {
        $this->config = $config;
    }

    // -------------------------------------------------------------------------

    /**
     * Zwraca tablicę wygenerowanych metadanych dla przekazanego obiektu
     * wraz ze sposobem generowania poszczególnych danych.
     *
     * @param object $obj
     * @return array
     */
    public function getCookie()
    {
        if (boolval(intval($this->config->get('cookie.enable')))) {
            return sprintf(
                '<!--googleoff: all--><div class="cookiesMessages hide %s %s"><div class="cookiesContent">%s</div><div class="cookiesButton"><button class="cButtonClose"><span>%s</span></button> </div> </div><!--googleon: all-->',
                $this->config->get('cookie.type'),
                $this->config->get('cookie.skin'),
                $this->config->get('cookie.content'),
                $this->config->get('cookie.buttonLabel')
            );
        }
        return;
    }
}
