<?php

namespace Wi\Admin\CoreBundle\Service;

class Array2Xml
{
    public $dom;

    public function __construct()
    {
        $this->dom = new \DOMDocument('1.0', 'UTF-8');
        $this->dom->formatOutput = TRUE;
    }

    public function parse($var, $node = null, $node_name = null)
    {
        if (is_null($node)) {
            $node = $this->dom;
        }

        if (! is_null($node_name)) {
            $node2 = $this->dom->createElement($node_name);

            if (array_key_exists('xmlns', $var) || array_key_exists('xmlns:image', $var)) {
                if (array_key_exists('xmlns', $var)) {
                    $node2->setAttributeNS('http://www.w3.org/2000/xmlns/', 'xmlns', $var['xmlns']);
                    unset($var['xmlns']);
                }

                if (array_key_exists('xmlns:image', $var)) {
                    $node2->setAttributeNS('http://www.w3.org/2000/xmlns/', 'xmlns:image', $var['xmlns:image']);
                    unset($var['xmlns:image']);
                }
            }

            $node->appendChild($node2);
            $node = $node2;
        }

        if (is_array($var)) {
            foreach ($var as $key => $value) {
                if (is_numeric($key)) {
                    $key = NULL;
                }

                if (is_array($value)) {
                    $this->parse($value, $node, $key);
                }

                if (is_numeric($value) || is_string($value)) {
                    $kluczyk = $node->appendChild($this->dom->createElement($key));
                    $kluczyk->appendChild($this->dom->createTextNode($value));
                }
            }
        }

        return $this->dom;
    }
}
