<?php $view->extend('::wicms.html.php'); ?>

<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_core_sitemap_index')); ?>
<?php $view['slots']->set('title', $view['translator']->trans('sitemap.meta.title', [], 'sitemap')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/lib/codemirror.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/sitemap.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li>
    <?php echo $view['translator']->trans('main-menu.administration'); ?>
</li>
<li><a href="<?php echo $view['router']->path('wi_admin_core_sitemap_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.sitemap', [], 'sitemap'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<i class="icon-sitemap"></i><?php echo $view['translator']->trans('sitemap.title', [], 'sitemap'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>

<?php echo $view['form']->start($form); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title"><i class="icon-sitemap"></i>
                <span><?php echo $view['translator']->trans('sitemap.title', [], 'sitemap'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('sitemap.multifile.title', [], 'sitemap'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('sitemap.multifile.desc', [], 'sitemap'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['sitemap_multifile']); ?>
                    </div>
                    <div>
                        <?php echo $view['form']->widget($form['sitemap_multifile']); ?>
                        <label class="switch-paddle" for="<?php echo $form->children['sitemap_multifile']->vars['id']; ?>">
                            <span class="show-for-sr"></span>
                            <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                            <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                        </label>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('sitemap.splitPagesPerGroup.title', [], 'sitemap'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('sitemap.splitPagesPerGroup.desc', [], 'sitemap'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['sitemap_splitPagesPerGroup']); ?>
                    </div>
                    <div>
                        <?php echo $view['form']->widget($form['sitemap_splitPagesPerGroup']); ?>
                        <label class="switch-paddle" for="<?php echo $form->children['sitemap_splitPagesPerGroup']->vars['id']; ?>">
                            <span class="show-for-sr"></span>
                            <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                            <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                        </label>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('sitemap.includePageImage.title', [], 'sitemap'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('sitemap.includePageImage.desc', [], 'sitemap'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['sitemap_includePageImage']); ?>
                    </div>
                    <div>
                        <?php echo $view['form']->widget($form['sitemap_includePageImage']); ?>
                        <label class="switch-paddle" for="<?php echo $form->children['sitemap_includePageImage']->vars['id']; ?>">
                            <span class="show-for-sr"></span>
                            <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                            <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                        </label>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('sitemap.splitNewsPerCategory.title', [], 'sitemap'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('sitemap.splitNewsPerCategory.desc', [], 'sitemap'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['sitemap_splitNewsPerCategory']); ?>
                    </div>
                    <div>
                        <?php echo $view['form']->widget($form['sitemap_splitNewsPerCategory']); ?>
                        <label class="switch-paddle" for="<?php echo $form->children['sitemap_splitNewsPerCategory']->vars['id']; ?>">
                            <span class="show-for-sr"></span>
                            <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                            <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                        </label>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('sitemap.splitNewsPerMonth.title', [], 'sitemap'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('sitemap.splitNewsPerMonth.desc', [], 'sitemap'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['sitemap_splitNewsPerMonth']); ?>
                    </div>
                    <div>
                        <?php echo $view['form']->widget($form['sitemap_splitNewsPerMonth']); ?>
                        <label class="switch-paddle" for="<?php echo $form->children['sitemap_splitNewsPerMonth']->vars['id']; ?>">
                            <span class="show-for-sr"></span>
                            <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                            <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                        </label>
                    </div>
                </div>
            </div>
            <?php /* ?>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('sitemap.splitGalleriesPerAlbum.title', [], 'sitemap'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('sitemap.splitGalleriesPerAlbum.desc', [], 'sitemap'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['sitemap_splitGalleriesPerAlbum']); ?>
                    </div>
                    <div>
                        <?php echo $view['form']->widget($form['sitemap_splitGalleriesPerAlbum']); ?>
                        <label class="switch-paddle" for="<?php echo $form->children['sitemap_splitGalleriesPerAlbum']->vars['id']; ?>">
                            <span class="show-for-sr"></span>
                            <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                            <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                        </label>
                    </div>
                </div>
            </div>
            <?php */ ?>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('sitemap.includeNewsImage.title', [], 'sitemap'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('sitemap.includeNewsImage.desc', [], 'sitemap'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['sitemap_includeNewsImage']); ?>
                    </div>
                    <div>
                        <?php echo $view['form']->widget($form['sitemap_includeNewsImage']); ?>
                        <label class="switch-paddle" for="<?php echo $form->children['sitemap_includeNewsImage']->vars['id']; ?>">
                            <span class="show-for-sr"></span>
                            <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                            <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                        </label>
                    </div>
                </div>
            </div>
            <?php /* ?>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('sitemap.includeGalleryImages.title', [], 'sitemap'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('sitemap.includeGalleryImages.desc', [], 'sitemap'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['sitemap_includeGalleryImages']); ?>
                    </div>
                    <div>
                        <?php echo $view['form']->widget($form['sitemap_includeGalleryImages']); ?>
                        <label class="switch-paddle" for="<?php echo $form->children['sitemap_includeGalleryImages']->vars['id']; ?>">
                            <span class="show-for-sr"></span>
                            <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                            <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                        </label>
                    </div>
                </div>
            </div>
            <?php */ ?>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('sitemap.showImagePublicIndex.title', [], 'sitemap'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('sitemap.showImagePublicIndex.desc', [], 'sitemap'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['sitemap_showImagePublicIndex']); ?>
                    </div>
                    <div>
                        <?php echo $view['form']->widget($form['sitemap_showImagePublicIndex']); ?>
                        <label class="switch-paddle" for="<?php echo $form->children['sitemap_showImagePublicIndex']->vars['id']; ?>">
                            <span class="show-for-sr"></span>
                            <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                            <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                        </label>
                    </div>
                </div>
            </div>

            <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
                <i class="icon-edit"></i>
                <?php echo $view['translator']->trans('Form.send'); ?>
            </button>
        </div>
    </div>

    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title"><i class="icon-sitemap"></i>
                <span><?php echo $view['translator']->trans('sitemap.generate_title', [], 'sitemap'); ?></span>
            </h3>
        </div>
        <div class="box-body " style="display: block;">
            <a href="<?php echo $view['router']->path('wi_admin_core_sitemap_generate'); ?>" class="button"><?php echo $view['translator']->trans('sitemap.generate.xml', [], 'sitemap'); ?></a>
        </div>
    </div>

    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title"><i class="icon-sitemap"></i>
                <span><?php echo $view['translator']->trans('sitemap.preview_title', [], 'sitemap'); ?></span>
            </h3>
        </div>
        <div class="box-body " style="display: block;">
            <div class="input-group">
                <input class="input-group-field sitemap-link" type="text" id="sitemap_link" placeholder="<?php echo $view['translator']->trans('sitemap.preview.load_link_placeholder', [], 'sitemap'); ?>">
                <div class="input-group-button">
                    <a id="load" class="load button"><?php echo $view['translator']->trans('sitemap.preview.load_xml', [], 'sitemap'); ?></a>
                    <a id="load-reset" class="load button secondary"><?php echo $view['translator']->trans('sitemap.preview.load_reset_xml', [], 'sitemap'); ?></a>
                </div>
            </div>

            <textarea name="dupa" class="editor-html" id="root_most_ajax_element" rows="20" readonly></textarea>
        </div>
    </div>
<?php echo $view['form']->end($form); ?>

<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script>
    var sitemap_link = '<?php echo $view['assets']->getUrl('sitemap.xml'); ?>';
</script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/lib/codemirror.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/mode/xml/xml.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/mode/javascript/javascript.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/mode/css/css.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/mode/vbscript/vbscript.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/mode/htmlmixed/htmlmixed.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/sitemap.js'); ?>"></script>

<?php $view['slots']->stop(); ?>
