<table class="table-seo">
    <thead>
        <tr>
            <th><?php echo $view['translator']->trans('seo.table.id', [], 'seo'); ?></th>
            <th><?php echo $view['translator']->trans('seo.table.title', [], 'seo'); ?></th>
            <th><?php echo $view['translator']->trans('seo.table.meta_title', [], 'seo'); ?></th>
            <th><?php echo $view['translator']->trans('seo.table.meta_description', [], 'seo'); ?></th>
            <th><?php echo $view['translator']->trans('seo.table.meta_keywords', [], 'seo'); ?></th>
            <th><?php echo $view['translator']->trans('seo.table.canonical', [], 'seo'); ?></th>
            <th><?php echo $view['translator']->trans('seo.table.image', [], 'seo'); ?></th>
        </tr>
    </thead>
    <tbody>
    <?php foreach ($newsCategories as $newsCategory): ?>
        <?php $metadata = $view['seo']->getMetaArray($newsCategory); ?>
        <tr>
            <td>
                <?php echo $newsCategory->getId(); ?>.
            </td>
            <td class="edit-hover">
                <?php echo $newsCategory->getName(); ?>
                <?php if ($view['security']->isGranted('ROLE_NEWS_EDIT')): ?>
                    <a href="<?php echo $view['router']->path('wi_admin_news_categories_edit', ['id' => $newsCategory->getId()]); ?>" class="edit-button" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                        <span><i class="icon-edit"></i></span>
                    </a>
                <?php endif ?>
            </td>
            <td class="length-attr">
                <div class="length-attr-inner"><sup class="generate-length gen-length-<?php echo $metadata['title']['length']['status']; ?>">[<?php echo $metadata['title']['length']['length']; ?>]</sup></div>
                <span class="generate-type type-<?php echo $metadata['title']['type']; ?>"><?php echo $metadata['title']['value']; ?></span>
            </td>
            <td class="length-attr">
                <div class="length-attr-inner"><sup class="generate-length gen-length-<?php echo $metadata['description']['length']['status']; ?>">[<?php echo $metadata['description']['length']['length']; ?>]</sup></div>
                <span class="generate-type type-<?php echo $metadata['description']['type']; ?>"><?php echo $metadata['description']['value']; ?></span>
            </td>
            <td><span class="generate-type type-<?php echo $metadata['keywords']['type']; ?>"><?php echo $metadata['keywords']['value']; ?></span></td>
            <td><span class="generate-type type-<?php echo $metadata['canonical']['type']; ?>"><?php echo $metadata['canonical']['value']; ?></span></td>
            <td><span class="generate-type type-<?php echo $metadata['image']['type']; ?>"><?php echo $metadata['image']['value'] ? $view['translator']->trans('yes') : $view['translator']->trans('no'); ?></span></td>
        </tr>
    <?php endforeach ?>
    </tbody>
</table>
