<?php $view->extend('::wicms.html.php'); ?>

<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_core_config_news')); ?>
<?php $view['slots']->set('title', $view['translator']->trans('configuration.meta.title', [], 'config')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/lib/codemirror.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/configuration.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li>
    <?php echo $view['translator']->trans('main-menu.administration'); ?>
</li>
<li>
    <?php echo $view['translator']->trans('main-menu.configuration.title'); ?>
</li>
<li><a href="<?php echo $view['router']->path('wi_admin_core_config_metadata'); ?>"><?php echo $view['translator']->trans('breadcrumbs.configuration_metadata', [], 'config'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<i class="icon-chart-bar-2"></i><?php echo $view['translator']->trans('configuration.metadata.title', [], 'config'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>

<?php echo $view['form']->start($form); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title"><i class="icon-chart-bar-2"></i>
                <span><?php echo $view['translator']->trans('configuration.metadata.title', [], 'config'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.metadata.Title.title', [], 'config'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('configuration.metadata.Title.desc', [], 'config'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['metadata_title']); ?>
                    </div>
                    <?php echo $view['form']->widget($form['metadata_title'], [
                        'attr' => [
                            'class' => $form['metadata_title']->vars['attr']['class'] . (! $form['metadata_title']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.metadata.titleForAllPages.title', [], 'config'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('configuration.metadata.titleForAllPages.desc', [], 'config'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['metadata_titleForAllPages']); ?>
                    </div>
                    <div>
                        <?php echo $view['form']->widget($form['metadata_titleForAllPages']); ?>
                        <label class="switch-paddle" for="<?php echo $form->children['metadata_titleForAllPages']->vars['id']; ?>">
                            <span class="show-for-sr"></span>
                            <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                            <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                        </label>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.metadata.TitleSeparator.title', [], 'config'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('configuration.metadata.TitleSeparator.desc', [], 'config'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['metadata_titleSeparator']); ?>
                    </div>
                    <?php echo $view['form']->widget($form['metadata_titleSeparator'], [
                        'attr' => [
                            'class' => $form['metadata_titleSeparator']->vars['attr']['class'] . (! $form['metadata_titleSeparator']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.metadata.desc.title', [], 'config'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('configuration.metadata.desc.desc', [], 'config'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['metadata_description']); ?>
                    </div>
                    <?php echo $view['form']->widget($form['metadata_description'], [
                        'attr' => [
                            'class' => $form['metadata_description']->vars['attr']['class'] . (! $form['metadata_description']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.metadata.keywordsEnable.title', [], 'config'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('configuration.metadata.keywordsEnable.desc', [], 'config'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['metadata_keywordsEnable']); ?>
                    </div>
                    <div>
                        <?php echo $view['form']->widget($form['metadata_keywordsEnable']); ?>
                        <label class="switch-paddle" for="<?php echo $form->children['metadata_keywordsEnable']->vars['id']; ?>">
                            <span class="show-for-sr"></span>
                            <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                            <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                        </label>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.metadata.keywords.title', [], 'config'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('configuration.metadata.keywords.desc', [], 'config'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['metadata_keywords']); ?>
                    </div>
                    <?php echo $view['form']->widget($form['metadata_keywords'], [
                        'attr' => [
                            'class' => $form['metadata_keywords']->vars['attr']['class'] . (! $form['metadata_keywords']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.metadata.keywordsForAllPages.title', [], 'config'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('configuration.metadata.keywordsForAllPages.desc', [], 'config'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['metadata_keywordsForAllPages']); ?>
                    </div>
                    <div>
                        <?php echo $view['form']->widget($form['metadata_keywordsForAllPages']); ?>
                        <label class="switch-paddle" for="<?php echo $form->children['metadata_keywordsForAllPages']->vars['id']; ?>">
                            <span class="show-for-sr"></span>
                            <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                            <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                        </label>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title"><i class="icon-chart-pie"></i>
                <span><?php echo $view['translator']->trans('configuration.metadata.og.title', [], 'config'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.metadata.openGraphEnable.title', [], 'config'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('configuration.metadata.openGraphEnable.desc', [], 'config'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['metadata_openGraphEnable']); ?>
                    </div>
                    <div>
                        <?php echo $view['form']->widget($form['metadata_openGraphEnable']); ?>
                        <label class="switch-paddle" for="<?php echo $form->children['metadata_openGraphEnable']->vars['id']; ?>">
                            <span class="show-for-sr"></span>
                            <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                            <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                        </label>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.metadata.openGraphDefaultImage.title', [], 'config'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('configuration.metadata.openGraphDefaultImage.desc', [], 'config'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['metadata_openGraphDefaultImage']); ?>
                    </div>
                    <?php echo $view['form']->widget($form['metadata_openGraphDefaultImage'], [
                        'attr' => [
                            'class' => $form['metadata_openGraphDefaultImage']->vars['attr']['class'] . (! $form['metadata_openGraphDefaultImage']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
        </div>
    </div>

    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title"><i class="icon-link"></i>
                <span><?php echo $view['translator']->trans('configuration.metadata.Canonical.title', [], 'config'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.metadata.canonical.title', [], 'config'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('configuration.metadata.canonical.desc', [], 'config'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['metadata_canonical']); ?>
                    </div>
                    <div>
                        <?php echo $view['form']->widget($form['metadata_canonical']); ?>
                        <label class="switch-paddle" for="<?php echo $form->children['metadata_canonical']->vars['id']; ?>">
                            <span class="show-for-sr"></span>
                            <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                            <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                        </label>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.metadata.canonicalForce.title', [], 'config'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('configuration.metadata.canonicalForce.desc', [], 'config'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['metadata_canonicalForce']); ?>
                    </div>
                    <div>
                        <?php echo $view['form']->widget($form['metadata_canonicalForce']); ?>
                        <label class="switch-paddle" for="<?php echo $form->children['metadata_canonicalForce']->vars['id']; ?>">
                            <span class="show-for-sr"></span>
                            <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                            <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                        </label>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title"><i class="icon-folder"></i>
                <span><?php echo $view['translator']->trans('configuration.metadata.other.title', [], 'config'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.metadata.otherHead.title', [], 'config'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('configuration.metadata.otherHead.desc', [], 'config'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['metadata_otherHead']); ?>
                    </div>
                    <?php echo $view['form']->widget($form['metadata_otherHead'], [
                        'attr' => [
                            'class' => $form['metadata_otherHead']->vars['attr']['class'] . (! $form['metadata_otherHead']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
        </div>
    </div>

    <div class="box">
        <div class="box-body " style="display: block;">
            <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
                <i class="icon-edit"></i>
                <?php echo $view['translator']->trans('Form.send'); ?>
            </button>
        </div>
    </div>
<?php echo $view['form']->end($form); ?>

<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/lib/codemirror.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/mode/xml/xml.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/mode/javascript/javascript.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/mode/css/css.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/mode/vbscript/vbscript.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/mode/htmlmixed/htmlmixed.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/configuration.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
