<?php $view->extend('::wicms.html.php'); ?>

<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_core_config_cookie')); ?>
<?php $view['slots']->set('title', $view['translator']->trans('configuration.meta.title', [], 'config')); ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/configuration.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li>
    <?php echo $view['translator']->trans('main-menu.administration'); ?>
</li>
<li>
    <?php echo $view['translator']->trans('main-menu.configuration.title'); ?>
</li>
<li><a href="<?php echo $view['router']->path('wi_admin_core_config_cookie'); ?>"><?php echo $view['translator']->trans('breadcrumbs.configuration_cookie', [], 'config'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<i class="icon-birthday"></i><?php echo $view['translator']->trans('configuration.cookie.title', [], 'config'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>

<?php echo $view['form']->start($form); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <h3 class="box-title">
            <i class="icon-birthday"></i>
            <span>
                <?php echo $view['translator']->trans('configuration.cookie.title', [], 'config'); ?>
            </span>
        </h3>
    </div>
    <div class="box-body" style="display: block;">
        <div class="row">
            <div class="large-2 columns">
                <p>
                    <strong>
                        <?php echo $view['translator']->trans('configuration.cookie.enable.title', [], 'config'); ?>
                    </strong>
                </p>
                <p>
                    <?php echo $view['translator']->trans('configuration.cookie.enable.desc', [], 'config'); ?>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert">
                    <?php echo $view['form']->errors($form['cookie_enable']); ?>
                </div>
                <div>
                    <?php echo $view['form']->widget($form['cookie_enable']); ?>
                    <label class="switch-paddle" for="<?php echo $form->children['cookie_enable']->vars['id']; ?>">
                        <span class="show-for-sr"></span>
                        <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                        <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                    </label>
                </div>
            </div>
        </div>
        <hr>
        <div class="enabledCookies">
            <div class="row">
                <div class="large-2 columns">
                    <p>
                        <strong>
                            <?php echo $view['translator']->trans('configuration.cookie.type.title', [], 'config'); ?>
                        </strong>
                    </p>
                    <p>
                        <?php echo $view['translator']->trans('configuration.cookie.type.desc', [], 'config'); ?>
                    </p>
                </div>
                <div class="large-10 columns">
                    <?php echo $view['form']->widget($form['cookie_type'], [
                        'attr' => [
                            'class' => $form['cookie_type']->vars['attr']['class'] . (! $form['cookie_type']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p>
                        <strong>
                            <?php echo $view['translator']->trans('configuration.cookie.skin.title', [], 'config'); ?>
                        </strong>
                    </p>
                    <p>
                        <?php echo $view['translator']->trans('configuration.cookie.skin.desc', [], 'config'); ?>
                    </p>
                </div>
                <div class="large-10 columns">
                    <?php echo $view['form']->widget($form['cookie_skin'], [
                        'attr' => [
                            'class' => $form['cookie_skin']->vars['attr']['class'] . (! $form['cookie_skin']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p>
                        <strong>
                            <?php echo $view['translator']->trans('configuration.cookie.buttonlabel.title', [], 'config'); ?>
                        </strong>
                    </p>
                    <p>
                        <?php echo $view['translator']->trans('configuration.cookie.buttonlabel.desc', [], 'config'); ?>
                    </p>
                </div>
                <div class="large-10 columns">
                    <?php echo $view['form']->widget($form['cookie_buttonLabel'], [
                        'attr' => [
                            'class' => $form['cookie_buttonLabel']->vars['attr']['class'] . (! $form['cookie_buttonLabel']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p>
                        <strong>
                            <?php echo $view['translator']->trans('configuration.cookie.content.title', [], 'config'); ?>
                        </strong>
                    </p>
                    <p>
                        <?php echo $view['translator']->trans('configuration.cookie.content.desc', [], 'config'); ?>
                    </p>
                </div>
                <div class="large-10 columns">
                    <?php echo $view['form']->widget($form['cookie_content'], [
                        'attr' => [
                            'class' => $form['cookie_content']->vars['attr']['class'] . (! $form['cookie_content']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="columns">
                <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
                    <i class="icon-edit"></i>
                    <?php echo $view['translator']->trans('Form.send'); ?>
                </button>
            </div>
        </div>
    </div>
</div>

<?php echo $view['form']->widget($form); ?>
<?php echo $view['form']->end($form); ?>

<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/js/select2.min.js') ?>" type="text/javascript"></script>
    <script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/tinymce/tinymce.min.js') ?>'></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/configuration.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
