<?php $view->extend('::wicms.html.php'); ?>

<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_core_config_comment')); ?>
<?php $view['slots']->set('title', $view['translator']->trans('configuration.meta.title', [], 'config')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/configuration.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li>
    <?php echo $view['translator']->trans('main-menu.administration'); ?>
</li>
<li>
    <?php echo $view['translator']->trans('main-menu.configuration.title'); ?>
</li>
<li><a href="<?php echo $view['router']->path('wi_admin_core_config_comment'); ?>"><?php echo $view['translator']->trans('breadcrumbs.configuration_comment', [], 'config'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<i class="icon-comment-empty"></i><?php echo $view['translator']->trans('configuration.comment.title', [], 'config'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('helpRightPanel') ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>

<?php echo $view['form']->start($form); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title"><i class="icon-comment-empty"></i>
                <span><?php echo $view['translator']->trans('configuration.comment.title', [], 'config'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-3 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.comment.enable.title', [], 'config'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('configuration.comment.enable.desc', [], 'config'); ?></p>
                </div>
                <div class="large-9 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['comment_enable']); ?>
                    </div>
                    <?php echo $view['form']->widget($form['comment_enable'], [
                        'attr' => [
                            'class' => $form['comment_enable']->vars['attr']['class'] . (! $form['comment_enable']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>

            <div id="comment-engine-wicms">
                <hr>
                <div class="row">
                    <div class="large-3 columns">
                        <p><strong><?php echo $view['translator']->trans('configuration.comment.enableLoginButton.title', [], 'config'); ?></strong></p>
                        <p><?php echo $view['translator']->trans('configuration.comment.enableLoginButton.desc', [], 'config'); ?></p>
                    </div>
                    <div class="large-9 columns">
                        <div class="formAlert">
                            <?php echo $view['form']->errors($form['comment_enableLoginButton']); ?>
                        </div>
                        <div>
                            <?php echo $view['form']->widget($form['comment_enableLoginButton']); ?>
                            <label class="switch-paddle" for="<?php echo $form->children['comment_enableLoginButton']->vars['id']; ?>">
                                <span class="show-for-sr"></span>
                                <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                                <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                            </label>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="large-3 columns">
                        <p><strong><?php echo $view['translator']->trans('configuration.comment.enableUserAutoAccept.title', [], 'config'); ?></strong></p>
                        <p><?php echo $view['translator']->trans('configuration.comment.enableUserAutoAccept.desc', [], 'config'); ?></p>
                    </div>
                    <div class="large-9 columns">
                        <div class="formAlert">
                            <?php echo $view['form']->errors($form['comment_enableUserAutoAccept']); ?>
                        </div>
                        <div>
                            <?php echo $view['form']->widget($form['comment_enableUserAutoAccept']); ?>
                            <label class="switch-paddle" for="<?php echo $form->children['comment_enableUserAutoAccept']->vars['id']; ?>">
                                <span class="show-for-sr"></span>
                                <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                                <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                            </label>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="large-3 columns">
                        <p><strong><?php echo $view['translator']->trans('configuration.comment.enableUserLimit.title', [], 'config'); ?></strong></p>
                        <p><?php echo $view['translator']->trans('configuration.comment.enableUserLimit.desc', [], 'config'); ?></p>
                    </div>
                    <div class="large-9 columns">
                        <div class="formAlert">
                            <?php echo $view['form']->errors($form['comment_enableUserLimit']); ?>
                        </div>
                        <div>
                            <?php echo $view['form']->widget($form['comment_enableUserLimit']); ?>
                            <label class="switch-paddle" for="<?php echo $form->children['comment_enableUserLimit']->vars['id']; ?>">
                                <span class="show-for-sr"></span>
                                <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                                <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                            </label>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="large-3 columns">
                        <p><strong><?php echo $view['translator']->trans('configuration.comment.userLimitValue.title', [], 'config'); ?></strong></p>
                        <p><?php echo $view['translator']->trans('configuration.comment.userLimitValue.desc', [], 'config'); ?></p>
                    </div>
                    <div class="large-9 columns">
                        <div class="formAlert">
                            <?php echo $view['form']->errors($form['comment_userLimitValue']); ?>
                        </div>
                        <?php echo $view['form']->widget($form['comment_userLimitValue'], [
                            'attr' => [
                                'class' => $form['comment_userLimitValue']->vars['attr']['class'] . (! $form['comment_userLimitValue']->vars['valid'] ? ' callout alert' : null),
                            ],
                        ]); ?> s
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="large-3 columns">
                        <p><strong><?php echo $view['translator']->trans('configuration.comment.enableGuest.title', [], 'config'); ?></strong></p>
                        <p><?php echo $view['translator']->trans('configuration.comment.enableGuest.desc', [], 'config'); ?></p>
                    </div>
                    <div class="large-9 columns">
                        <div class="formAlert">
                            <?php echo $view['form']->errors($form['comment_enableGuest']); ?>
                        </div>
                        <div>
                            <?php echo $view['form']->widget($form['comment_enableGuest']); ?>
                            <label class="switch-paddle" for="<?php echo $form->children['comment_enableGuest']->vars['id']; ?>">
                                <span class="show-for-sr"></span>
                                <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                                <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                            </label>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="large-3 columns">
                        <p><strong><?php echo $view['translator']->trans('configuration.comment.enableGuestAutoAccept.title', [], 'config'); ?></strong></p>
                        <p><?php echo $view['translator']->trans('configuration.comment.enableGuestAutoAccept.desc', [], 'config'); ?></p>
                    </div>
                    <div class="large-9 columns">
                        <div class="formAlert">
                            <?php echo $view['form']->errors($form['comment_enableGuestAutoAccept']); ?>
                        </div>
                        <div>
                            <?php echo $view['form']->widget($form['comment_enableGuestAutoAccept']); ?>
                            <label class="switch-paddle" for="<?php echo $form->children['comment_enableGuestAutoAccept']->vars['id']; ?>">
                                <span class="show-for-sr"></span>
                                <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                                <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                            </label>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="large-3 columns">
                        <p><strong><?php echo $view['translator']->trans('configuration.comment.enableGuestLimit.title', [], 'config'); ?></strong></p>
                        <p><?php echo $view['translator']->trans('configuration.comment.enableGuestLimit.desc', [], 'config'); ?></p>
                    </div>
                    <div class="large-9 columns">
                        <div class="formAlert">
                            <?php echo $view['form']->errors($form['comment_enableGuestLimit']); ?>
                        </div>
                        <div>
                            <?php echo $view['form']->widget($form['comment_enableGuestLimit']); ?>
                            <label class="switch-paddle" for="<?php echo $form->children['comment_enableGuestLimit']->vars['id']; ?>">
                                <span class="show-for-sr"></span>
                                <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                                <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                            </label>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="large-3 columns">
                        <p><strong><?php echo $view['translator']->trans('configuration.comment.guestLimitValue.title', [], 'config'); ?></strong></p>
                        <p><?php echo $view['translator']->trans('configuration.comment.guestLimitValue.desc', [], 'config'); ?></p>
                    </div>
                    <div class="large-9 columns">
                        <div class="formAlert">
                            <?php echo $view['form']->errors($form['comment_guestLimitValue']); ?>
                        </div>
                        <?php echo $view['form']->widget($form['comment_guestLimitValue'], [
                            'attr' => [
                                'class' => $form['comment_guestLimitValue']->vars['attr']['class'] . (! $form['comment_guestLimitValue']->vars['valid'] ? ' callout alert' : null),
                            ],
                        ]); ?> s
                    </div>
                </div>
            </div>

            <div id="comment-engine-disqus">
                <hr>
                <div class="row">
                    <div class="large-3 columns">
                        <p><strong><?php echo $view['translator']->trans('configuration.comment.disqusShortname.title', [], 'config'); ?></strong></p>
                        <p><?php echo $view['translator']->trans('configuration.comment.disqusShortname.desc', [], 'config'); ?></p>
                    </div>
                    <div class="large-9 columns">
                        <div class="formAlert">
                            <?php echo $view['form']->errors($form['comment_disqusShortname']); ?>
                        </div>
                        <?php echo $view['form']->widget($form['comment_disqusShortname'], [
                            'attr' => [
                                'class' => $form['comment_disqusShortname']->vars['attr']['class'] . (! $form['comment_disqusShortname']->vars['valid'] ? ' callout alert' : null),
                            ],
                        ]); ?>
                    </div>
                </div>
            </div>

            <div id="comment-engine-facebook">
                <hr>
                <div class="row">
                    <div class="large-3 columns">
                        <p><strong><?php echo $view['translator']->trans('configuration.comment.fbAppId.title', [], 'config'); ?></strong></p>
                        <p><?php echo $view['translator']->trans('configuration.comment.fbAppId.desc', [], 'config'); ?></p>
                    </div>
                    <div class="large-9 columns">
                        <div class="formAlert">
                            <?php echo $view['form']->errors($form['comment_fbAppId']); ?>
                        </div>
                        <?php echo $view['form']->widget($form['comment_fbAppId'], [
                            'attr' => [
                                'class' => $form['comment_fbAppId']->vars['attr']['class'] . (! $form['comment_fbAppId']->vars['valid'] ? ' callout alert' : null),
                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
            <hr>

            <button class="button" href="#" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
                <i class="icon-edit"></i>
                <?php echo $view['translator']->trans('Form.send'); ?>
            </button>
        </div>
    </div>
<?php echo $view['form']->end($form); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/configuration.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
