<?php $view->extend('::wicms.html.php'); ?>

<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_core_backup_database')); ?>
<?php $view['slots']->set('title', $view['translator']->trans('backup.meta.title', [], 'backup')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li>
    <?php echo $view['translator']->trans('main-menu.administration'); ?>
</li>
<li><a href="<?php echo $view['router']->path('wi_admin_core_seo_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.backup', [], 'backup'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<i class="icon-hdd"></i><?php echo $view['translator']->trans('backup.title', [], 'backup'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <h3 class="box-title"><i class="icon-database"></i>
            <span><?php echo $view['translator']->trans('backup.database_backup.title', [], 'backup'); ?></span>
        </h3>
    </div>
    <div class="box-body " style="display: block;">
        <table>
            <thead>
                <tr>
                    <th><?php echo $view['translator']->trans('backup.database_backup.table.date', [], 'backup'); ?></th>
                    <th><?php echo $view['translator']->trans('backup.database_backup.table.filename', [], 'backup'); ?></th>
                    <th><?php echo $view['translator']->trans('backup.database_backup.table.size', [], 'backup'); ?></th>
                    <?php if ($view['security']->isGranted('ROLE_BACKUP_FULL')): ?>
                        <th></th>
                        <th></th>
                        <th></th>
                    <?php endif; ?>
                </tr>
            </thead>
            <tbody>
            <?php foreach ($backupList as $file): ?>
                <tr>
                    <td><?php echo date('Y-m-d H:i:s', $file['file']->getCTime()); ?></td>
                    <td><?php echo $file['filename']; ?></td>
                    <td><?php echo $view['front']->formatBytes($file['file']->getSize()); ?></td>
                    <?php if ($view['security']->isGranted('ROLE_BACKUP_FULL')): ?>
                        <td><a href="<?php echo $view['router']->path('wi_admin_core_backup_database_download', ['filename' => $file['filename']]); ?>"><?php echo $view['translator']->trans('backup.database_backup.download', [], 'backup'); ?></a></td>
                        <td><a href="<?php echo $view['router']->path('wi_admin_core_backup_database_restore', ['filename' => $file['filename']]); ?>"><?php echo $view['translator']->trans('backup.database_backup.restore', [], 'backup'); ?></a></td>
                        <td><a href="<?php echo $view['router']->path('wi_admin_core_backup_database_remove', ['filename' => $file['filename']]); ?>"><?php echo $view['translator']->trans('backup.database_backup.delete', [], 'backup'); ?></a></td>
                    <?php endif; ?>
                </tr>
            <?php endforeach ?>
            </tbody>
        </table>
        <hr>
        <a href="<?php echo $view['router']->path('wi_admin_core_backup_database_generate'); ?>" class="button"><?php echo $view['translator']->trans('backup.database_backup.generate', [], 'backup'); ?></a>
    </div>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<?php $view['slots']->stop(); ?>
