<?php

namespace Wi\Admin\CoreBundle\Form\Config;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints as Assert;
use Wi\Admin\NewsBundle\Comment\CommentEngineInterface;

/**
 * Config comment Type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class CommentType extends AbstractType
{
    /**
     * @var EntityManagerInterface
     */
    private $em;

    /**
     * Constructor.
     *
     * @param EntityManagerInterface $em
     */
    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $enable = $this->getConfig('comment', 'enable');
        $enableLoginButton = $this->getConfig('comment', 'enableLoginButton');
        $enableUserAutoAccept = $this->getConfig('comment', 'enableUserAutoAccept');
        $enableGuestAutoAccept = $this->getConfig('comment', 'enableGuestAutoAccept');
        $enableGuest = $this->getConfig('comment', 'enableGuest');
        $enableUserLimit = $this->getConfig('comment', 'enableUserLimit');
        $userLimitValue = $this->getConfig('comment', 'userLimitValue');
        $enableGuestLimit = $this->getConfig('comment', 'enableGuestLimit');
        $guestLimitValue = $this->getConfig('comment', 'guestLimitValue');
        $disqusShortname = $this->getConfig('comment', 'disqusShortname');
        $fbAppId = $this->getConfig('comment', 'fbAppId');

        $builder
            ->add('comment_enable', ChoiceType::class, [
                'attr' => [
                    'class' => '',
                ],
                'choices' => [
                    'configuration.comment.enable.options.disable' => CommentEngineInterface::DISABLE,
                    'configuration.comment.enable.options.wicms' => CommentEngineInterface::WICMS,
                    'configuration.comment.enable.options.facebook' => CommentEngineInterface::FACEBOOK,
                    'configuration.comment.enable.options.disqus' => CommentEngineInterface::DISQUS,
                ],
                'choice_translation_domain' => 'config',
                'constraints' => [],
                'data' => $enable->getValue(),
                'required' => true,
            ])
            ->add('comment_enableLoginButton', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($enableLoginButton->getValue())),
                'label' => false,
                'required' => false,
            ])
            ->add('comment_enableUserAutoAccept', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($enableUserAutoAccept->getValue())),
                'label' => false,
                'required' => false,
            ])
            ->add('comment_enableGuestAutoAccept', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($enableGuestAutoAccept->getValue())),
                'label' => false,
                'required' => false,
            ])
            ->add('comment_enableGuest', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($enableGuest->getValue())),
                'label' => false,
                'required' => false,
            ])
            ->add('comment_enableUserLimit', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($enableUserLimit->getValue())),
                'label' => false,
                'required' => false,
            ])
            ->add('comment_userLimitValue', IntegerType::class, [
                'attr' => [
                    'class' => 'news-config-dimensions',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                    new Assert\GreaterThan([
                        'value' => 0,
                    ]),
                ],
                'data' => $userLimitValue->getValue(),
                'required' => true,
            ])
            ->add('comment_enableGuestLimit', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($enableGuestLimit->getValue())),
                'label' => false,
                'required' => false,
            ])
            ->add('comment_guestLimitValue', IntegerType::class, [
                'attr' => [
                    'class' => 'news-config-dimensions',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                    new Assert\GreaterThan([
                        'value' => 0,
                    ]),
                ],
                'data' => $guestLimitValue->getValue(),
                'required' => true,
            ])
            ->add('comment_disqusShortname', TextType::class, [
                'attr' => [
                    'class' => '',
                    'placeholder' => 'configuration.comment.disqusShortname.placeholder',
                ],
                'data' => $disqusShortname->getValue(),
                'required' => false,
                'translation_domain' => 'config',
            ])
            ->add('comment_fbAppId', TextType::class, [
                'attr' => [
                    'class' => '',
                ],
                'data' => $fbAppId->getValue(),
                'required' => false,
                'translation_domain' => 'config',
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'config_comment_edit';
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Pobiera parametr konfiguracji na podstawie przekazanych atrybutów.
     *
     * @param string $groupName
     * @param string $name
     * @return Config
     */
    private function getConfig($groupName, $name)
    {
        return $this->em->getRepository('WiAdminCoreBundle:Config')
            ->findOneBy([
                'groupName' => $groupName,
                'name' => $name,
            ])
        ;
    }
}
