<?php

namespace Wi\Admin\CoreBundle\Error;

use Symfony\Component\Debug\Exception\FlattenException;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\GetResponseForExceptionEvent;
use Symfony\Component\HttpKernel\HttpKernelInterface;
use Symfony\Component\HttpKernel\KernelEvents;
use Symfony\Component\HttpKernel\Log\DebugLoggerInterface;

class ExceptionSubscriber implements EventSubscriberInterface
{
    private $controller;
    private $debug;
    private $logger;

    public function __construct($controller, bool $debug, LoggerInterface $logger = null)
    {
        $this->controller = $controller;
        $this->debug = $debug;
        $this->logger = $logger;
    }

    public function onKernelException(GetResponseForExceptionEvent $event)
    {
        static $handing;

        if ($this->debug) {
            return;
        }

        if (true === $handing) {
            return false;
        }

        $handling = true;

        $exception = $event->getException();
        $request = $event->getRequest();

        $attributes = [
            '_controller' => $this->controller,
            'exception'   => FlattenException::create($exception),
            'logger'      => $this->logger instanceof DebugLoggerInterface ? $this->logger : null,
            'format'      => $request->getRequestFormat(),
        ];

        $request = $request->duplicate(null, null, $attributes);
        $request->setMethod('GET');

        try {
            $response = $event->getKernel()->handle($request, HttpKernelInterface::SUB_REQUEST, true);
        } catch (\Exception $e) {
            $handling = false;
            return;
        }

        $event->setResponse($response);

        $handling = false;
    }

    public static function getSubscribedEvents()
    {
        return array(
            KernelEvents::EXCEPTION => 'onKernelException',
        );
    }
}
