<?php

namespace Wi\Admin\CoreBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Wi\Admin\CoreBundle\Entity\MenuGroup;

/**
 * Załadowanie menu do bazy danych.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LoadMenuGroupData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritdoc}
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->getData() as $data) {
            $menu = $this->getMenuGroup($data);
            $this->addReference('cb-menu-group-'.$data['id'], $menu);

            // Przygotowanie do zapisu.
            $manager->persist($menu);

            // Wymuszenie podania ID.
            $metadata = $manager->getClassMetaData(get_class($menu));
            $metadata->setIdGeneratorType(\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_NONE);
        }

        // Zapis.
        $manager->flush();
    }

    /**
     * {@inheritdoc}
     */
    public function getOrder()
    {
        return 2;
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Tablica danych.
     *
     * @return mixed[]
     */
    private function getData()
    {
        return [
            ['id' => 1, 'name' => 'Main Menu'],
            ['id' => 2, 'name' => 'Main Menu - small'],
        ];
    }

    /**
     * Tworzy obiekt nowego wpisu konfiguracji na podstawie przekazanej
     * tablicy danych.
     *
     * @param   array $data
     * @return  \Wi\Admin\CoreBundle\Entity\MenuGroup
     */
    private function getMenuGroup(array $data)
    {
        return (new MenuGroup())
            ->setId($data['id'])
            ->setName($data['name'])
        ;
    }
}
