<?php

namespace Wi\Admin\CoreBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Wi\Admin\CoreBundle\Entity\Menu;

/**
 * Załadowanie menu do bazy danych.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LoadMenuData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritdoc}
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->getData() as $data) {
            $menu = $this->getMenu($data);
            $this->addReference('cb-menu-'.$data['id'], $menu);

            // Przygotowanie do zapisu.
            $manager->persist($menu);

            // Wymuszenie podania ID.
            $metadata = $manager->getClassMetaData(get_class($menu));
            $metadata->setIdGeneratorType(\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_NONE);
        }

        // Zapis.
        $manager->flush();
    }

    /**
     * {@inheritdoc}
     */
    public function getOrder()
    {
        return 3;
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Tablica danych.
     *
     * @return mixed[]
     */
    private function getData()
    {
        return [
            // Dashboard
            [
                'id' => 100,
                'group_id' => 1,
                'parent_id' => null,
                'orderNr' => 1,
                'name' => 'main-menu.dashboard',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_admin_dashboard',
                'routeParams' => [],
                'class' => 'bg icon-desktop palette-Green-Menu',
                'advanced' => false,
                'permission' => ['ROLE_ADMIN'],
            ],
            // CMS Basic
            [
                'id' => 200,
                'group_id' => 1,
                'parent_id' => null,
                'orderNr' => 2,
                'name' => 'main-menu.content',
                'enableLink' => true,
                'link' => '#',
                'routeName' => null,
                'routeParams' => [],
                'class' => 'bg icon-newspaper palette-Green-Menu',
                'advanced' => false,
                'permission' => ['ROLE_NEWS_INDEX', 'ROLE_PAGES_INDEX', 'ROLE_MEDIA_INDEX', 'ROLE_CONTACT_INDEX'],
            ],
            [
                'id' => 210,
                'group_id' => 1,
                'parent_id' => 200,
                'orderNr' => 2,
                'name' => 'main-menu.news',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_news_index',
                'routeParams' => [],
                'class' => 'bg icon-newspaper-1 palette-Green-Menu kolorIkony',
                'advanced' => false,
                'permission' => ['ROLE_NEWS_INDEX'],
            ],
            [
                'id' => 220,
                'group_id' => 1,
                'parent_id' => 200,
                'orderNr' => 1,
                'name' => 'main-menu.pages',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_pages_index',
                'routeParams' => [],
                'class' => 'bg icon-doc-text-1 palette-Green-Menu kolorIkony',
                'advanced' => false,
                'permission' => ['ROLE_PAGES_INDEX'],
            ],
            [
                'id' => 230,
                'group_id' => 1,
                'parent_id' => 200,
                'orderNr' => 6,
                'name' => 'main-menu.media',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_media_index',
                'routeParams' => [],
                'class' => 'bg icon-file-image palette-Green-Menu kolorIkony',
                'advanced' => false,
                'permission' => ['ROLE_MEDIA_INDEX'],
            ],
            [
                'id' => 240,
                'group_id' => 1,
                'parent_id' => 200,
                'orderNr' => 5,
                'name' => 'main-menu.contact',
                'enableLink' => true,
                'link' => '#',
                'routeName' => null,
                'routeParams' => [],
                'class' => 'bg icon-post palette-Green-Menu kolorIkony',
                'advanced' => false,
                'permission' => ['ROLE_CONTACT_INDEX'],
            ],
            [
                'id' => 241,
                'group_id' => 1,
                'parent_id' => 240,
                'orderNr' => 1,
                'name' => 'main-menu.contactEdit',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_contact_index',
                'routeParams' => [],
                'class' => 'bg icon-edit palette-Green-Menu kolorIkony',
                'advanced' => false,
                'permission' => ['ROLE_CONTACT_INDEX'],
            ],
            [
                'id' => 242,
                'group_id' => 1,
                'parent_id' => 240,
                'orderNr' => 2,
                'name' => 'main-menu.contactInboxForm',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_contact_messages_all',
                'routeParams' => [],
                'class' => 'bg icon-post palette-Green-Menu kolorIkony inboxContactMenu',
                'advanced' => false,
                'permission' => ['ROLE_CONTACT_INDEX'],
            ],
            [
                'id' => 243,
                'group_id' => 1,
                'parent_id' => 240,
                'orderNr' => 3,
                'name' => 'main-menu.contactInboxLead',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_contact_leads',
                'routeParams' => [],
                'class' => 'bg icon-comment palette-Green-Menu kolorIkony inboxLeadMenu',
                'advanced' => false,
                'permission' => ['ROLE_CONTACT_INDEX'],
            ],
            [
                'id' => 250,
                'group_id' => 1,
                'parent_id' => 200,
                'orderNr' => 3,
                'name' => 'main-menu.blog',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_blog_index',
                'routeParams' => [],
                'class' => 'bg icon-doc palette-Green-Menu kolorIkony',
                'advanced' => false,
                'permission' => ['ROLE_BLOG_INDEX'],
            ],
            [
                'id' => 260,
                'group_id' => 1,
                'parent_id' => 200,
                'orderNr' => 4,
                'name' => 'main-menu.faq',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_faq_question_index',
                'routeParams' => [],
                'class' => 'bg icon-help-circled palette-Green-Menu kolorIkony',
                'advanced' => false,
                'permission' => ['ROLE_FAQ_INDEX'],
            ],
            [
                'id' => 270,
                'group_id' => 1,
                'parent_id' => 200,
                'orderNr' => 7,
                'name' => 'main-menu.newsletter',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_newsletter_mainsite_index',
                'routeParams' => [],
                'class' => 'bg icon-mail palette-Green-Menu kolorIkony',
                'advanced' => false,
                'permission' => ['ROLE_NEWSLETTER_INDEX'],
            ],

            // CMS Advanced
            [
                'id' => 300,
                'group_id' => 1,
                'parent_id' => null,
                'orderNr' => 3,
                'name' => 'main-menu.cmsAdvanced',
                'enableLink' => true,
                'link' => '#',
                'routeName' => null,
                'routeParams' => [],
                'class' => 'bg icon-website palette-Green-Menu',
                'advanced' => false,
                'permission' => ['ROLE_BLOCKS_INDEX', 'ROLE_FAQ_INDEX', 'ROLE_MENU_INDEX'],
            ],
            [
                'id' => 310,
                'group_id' => 1,
                'parent_id' => 300,
                'orderNr' => 2,
                'name' => 'main-menu.block',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_block_itemHTML_index',
                'routeParams' => [],
                'class' => 'bg icon-menu-outline palette-Green-Menu kolorIkony',
                'advanced' => false,
                'permission' => ['ROLE_BLOCKS_INDEX'],
            ],
            [
                'id' => 330,
                'group_id' => 1,
                'parent_id' => 300,
                'orderNr' => 4,
                'name' => 'main-menu.menu',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_menu_index',
                'routeParams' => [],
                'class' => 'bg icon-menu palette-Green-Menu kolorIkony',
                'advanced' => false,
                'permission' => ['ROLE_MENU_INDEX'],
            ],
            [
                'id' => 340,
                'group_id' => 1,
                'parent_id' => 300,
                'orderNr' => 5,
                'name' => 'main-menu.link',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_link_index',
                'routeParams' => [],
                'class' => 'bg icon-link palette-Green-Menu kolorIkony',
                'advanced' => false,
                'permission' => ['ROLE_LINK_INDEX'],
            ],
            [
                'id' => 350,
                'group_id' => 1,
                'parent_id' => 300,
                'orderNr' => 6,
                'name' => 'main-menu.advertisement',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_advertising_block_index',
                'routeParams' => [],
                'class' => 'bg icon-megaphone palette-Green-Menu kolorIkony',
                'advanced' => false,
                'permission' => ['ROLE_ADVERTISEMENT_INDEX'],
            ],
            [
                'id' => 360,
                'group_id' => 1,
                'parent_id' => 300,
                'orderNr' => 1,
                'name' => 'main-menu.banner',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_banner_index',
                'routeParams' => [],
                'class' => 'bg icon-picture palette-Green-Menu kolorIkony',
                'advanced' => false,
                'permission' => ['ROLE_BANNER_INDEX'],
            ],
            [
                'id' => 370,
                'group_id' => 1,
                'parent_id' => 300,
                'orderNr' => 3,
                'name' => 'main-menu.comment',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_news_comment_index',
                'routeParams' => [],
                'class' => 'bg icon-comment-empty palette-Green-Menu kolorIkony',
                'advanced' => false,
                'permission' => ['ROLE_NEWS_INDEX', 'ROLE_BLOG_INDEX'],
            ],
            [
                'id' => 380,
                'group_id' => 1,
                'parent_id' => 300,
                'orderNr' => 7,
                'name' => 'main-menu.files',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_download_file_index',
                'routeParams' => [],
                'class' => 'bg icon-docs palette-Green-Menu kolorIkony',
                'advanced' => false,
                'permission' => ['ROLE_FILE_INDEX'],
            ],
            // Administration
            [
                'id' => 400,
                'group_id' => 1,
                'parent_id' => null,
                'orderNr' => 4,
                'name' => 'main-menu.administration',
                'enableLink' => true,
                'link' => '#',
                'routeName' => null,
                'routeParams' => [],
                'class' => 'bg icon-globe palette-Blue-Menu ',
                'advanced' => false,
                'permission' => ['ROLE_ADMINISTRATORS_INDEX', 'ROLE_USERS_INDEX', 'ROLE_SEO_INDEX', 'ROLE_REST_API_DOC', 'ROLE_BACKUP_INDEX'],
            ],
            [
                'id' => 410,
                'group_id' => 1,
                'parent_id' => 400,
                'orderNr' => 1,
                'name' => 'main-menu.admin',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_admin_administrators_index',
                'routeParams' => [],
                'class' => 'bg icon-users-outline  kolorIkonyBlue',
                'advanced' => false,
                'permission' => ['ROLE_ADMINISTRATORS_INDEX'],
            ],
            [
                'id' => 420,
                'group_id' => 1,
                'parent_id' => 400,
                'orderNr' => 2,
                'name' => 'main-menu.users',
                'enableLink' => true,
                'link' => '#',
                'routeName' => null,
                'routeParams' => [],
                'class' => 'bg icon-users  kolorIkonyBlue',
                'advanced' => false,
                'permission' => ['ROLE_USERS_INDEX'],
            ],
            [
                'id' => 421,
                'group_id' => 1,
                'parent_id' => 420,
                'orderNr' => 1,
                'name' => 'main-menu.userList',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_users_index',
                'routeParams' => [],
                'class' => 'bg icon-users  ',
                'advanced' => false,
                'permission' => ['ROLE_USERS_INDEX'],
            ],
            [
                'id' => 422,
                'group_id' => 1,
                'parent_id' => 420,
                'orderNr' => 2,
                'name' => 'main-menu.userLogs',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_users_logs_index',
                'routeParams' => [],
                'class' => 'bg icon-vcard  ',
                'advanced' => false,
                'permission' => ['ROLE_USERS_INDEX'],
            ],
            [
                'id' => 423,
                'group_id' => 1,
                'parent_id' => 420,
                'orderNr' => 3,
                'name' => 'main-menu.avatars',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_users_avatars_index',
                'routeParams' => [],
                'class' => 'bg icon-user-circle  ',
                'advanced' => false,
                'permission' => ['ROLE_USERS_INDEX'],
            ],
            [
                'id' => 424,
                'group_id' => 1,
                'parent_id' => 420,
                'orderNr' => 4,
                'name' => 'main-menu.interests',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_users_interests_index',
                'routeParams' => [],
                'class' => 'bg icon-bicycle  ',
                'advanced' => false,
                'permission' => ['ROLE_USERS_INDEX'],
            ],
            [
                'id' => 425,
                'group_id' => 1,
                'parent_id' => 420,
                'orderNr' => 5,
                'name' => 'main-menu.logType',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_users_log_types_index',
                'routeParams' => [],
                'class' => 'bg icon-th-list  ',
                'advanced' => false,
                'permission' => ['ROLE_USERS_INDEX'],
            ],
            [
                'id' => 430,
                'group_id' => 1,
                'parent_id' => 400,
                'orderNr' => 3,
                'name' => 'main-menu.seo',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_core_seo_index',
                'routeParams' => [],
                'class' => 'bg icon-cogs  kolorIkonyBlue',
                'advanced' => false,
                'permission' => ['ROLE_SEO_INDEX'],
            ],
            [
                'id' => 440,
                'group_id' => 1,
                'parent_id' => 400,
                'orderNr' => 5,
                'name' => 'main-menu.restApiDoc',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'nelmio_api_doc_index',
                'routeParams' => ['view' => 'v1'],
                'class' => 'bg icon-doc-text-1  kolorIkonyBlue',
                'advanced' => false,
                'permission' => ['ROLE_REST_API_DOC'],
            ],
            // Next group.
            [
                'id' => 450,
                'group_id' => 1,
                'parent_id' => 400,
                'orderNr' => 1,
                'name' => 'main-menu.configuration.title',
                'enableLink' => true,
                'link' => '#',
                'routeName' => null,
                'routeParams' => [],
                'class' => 'bg icon-cogs  kolorIkonyBlue',
                'advanced' => false,
                'permission' => ['ROLE_CONFIGURATION_INDEX'],
            ],
            [
                'id' => 451,
                'group_id' => 1,
                'parent_id' => 450,
                'orderNr' => 1,
                'name' => 'main-menu.configuration.contact',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_core_config_contact',
                'routeParams' => [],
                'class' => 'bg icon-post  kolorIkonyBlue',
                'advanced' => false,
                'permission' => ['ROLE_CONFIGURATION_INDEX'],
            ],
            [
                'id' => 452,
                'group_id' => 1,
                'parent_id' => 450,
                'orderNr' => 2,
                'name' => 'main-menu.configuration.ga',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_core_config_ga',
                'routeParams' => [],
                'class' => 'bg icon-chart-line  kolorIkonyBlue',
                'advanced' => false,
                'permission' => ['ROLE_CONFIGURATION_INDEX'],
            ],
            [
                'id' => 453,
                'group_id' => 1,
                'parent_id' => 450,
                'orderNr' => 3,
                'name' => 'main-menu.configuration.metadata',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_core_config_metadata',
                'routeParams' => [],
                'class' => 'bg icon-chart-bar-2  kolorIkonyBlue',
                'advanced' => false,
                'permission' => ['ROLE_CONFIGURATION_INDEX'],
            ],
            [
                'id' => 454,
                'group_id' => 1,
                'parent_id' => 450,
                'orderNr' => 4,
                'name' => 'main-menu.configuration.news',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_core_config_news',
                'routeParams' => [],
                'class' => 'bg icon-newspaper-1  kolorIkonyBlue',
                'advanced' => false,
                'permission' => ['ROLE_CONFIGURATION_INDEX'],
            ],
            [
                'id' => 455,
                'group_id' => 1,
                'parent_id' => 450,
                'orderNr' => 7,
                'name' => 'main-menu.configuration.all',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_core_config_index',
                'routeParams' => [],
                'class' => 'bg icon-cogs  kolorIkonyBlue',
                'advanced' => false,
                'permission' => ['ROLE_CONFIGURATION_INDEX'],
            ],
            [
                'id' => 456,
                'group_id' => 1,
                'parent_id' => 450,
                'orderNr' => 5,
                'name' => 'main-menu.configuration.cookie',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_core_config_cookie',
                'routeParams' => [],
                'class' => 'bg icon-birthday kolorIkonyBlue',
                'advanced' => false,
                'permission' => ['ROLE_CONFIGURATION_INDEX'],
            ],
            [
                'id' => 457,
                'group_id' => 1,
                'parent_id' => 450,
                'orderNr' => 5,
                'name' => 'main-menu.configuration.cache',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_core_cache_index',
                'routeParams' => [],
                'class' => 'bg icon-desktop kolorIkonyBlue',
                'advanced' => false,
                'permission' => ['ROLE_CONFIGURATION_INDEX'],
            ],
            [
                'id' => 458,
                'group_id' => 1,
                'parent_id' => 450,
                'orderNr' => 5,
                'name' => 'main-menu.configuration.comment',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_core_config_comment',
                'routeParams' => [],
                'class' => 'bg icon-comment-empty kolorIkonyBlue',
                'advanced' => false,
                'permission' => ['ROLE_CONFIGURATION_INDEX'],
            ],
            [
                'id' => 459,
                'group_id' => 1,
                'parent_id' => 450,
                'orderNr' => 6,
                'name' => 'main-menu.configuration.users',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_core_config_user',
                'routeParams' => [],
                'class' => 'bg icon-users kolorIkonyBlue',
                'advanced' => false,
                'permission' => ['ROLE_CONFIGURATION_INDEX'],
            ],
            [
                'id' => 460,
                'group_id' => 1,
                'parent_id' => 400,
                'orderNr' => 4,
                'name' => 'main-menu.configuration.sitemap',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_core_sitemap_index',
                'routeParams' => [],
                'class' => 'bg icon-sitemap kolorIkonyBlue',
                'advanced' => false,
                'permission' => ['ROLE_CONFIGURATION_INDEX'],
            ],
            [
                'id' => 470,
                'group_id' => 1,
                'parent_id' => 400,
                'orderNr' => 4,
                'name' => 'main-menu.backup',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_core_backup_database',
                'routeParams' => [],
                'class' => 'bg icon-hdd kolorIkonyBlue',
                'advanced' => false,
                'permission' => ['ROLE_BACKUP_INDEX'],
            ],
            [
                'id' => 461,
                'group_id' => 1,
                'parent_id' => 400,
                'orderNr' => 4,
                'name' => 'main-menu.analytics',
                'enableLink' => false,
                'link' => null,
                'routeName' => 'wi_admin_core_analytics_index',
                'routeParams' => [],
                'class' => 'bg icon-chart-bar-2 kolorIkonyBlue',
                'advanced' => false,
                'permission' => ['ROLE_SEO_INDEX'],
            ],
        ];
    }

    /**
     * Tworzy obiekt nowego wpisu konfiguracji na podstawie przekazanej
     * tablicy danych.
     *
     * @param   array $data
     * @return  \Wi\Admin\CoreBundle\Entity\Menu
     */
    private function getMenu(array $data)
    {
        return (new Menu())
            ->setId($data['id'])
            ->setGroup($this->getReference('cb-menu-group-'.$data['group_id']))
            ->setParent((! is_null($data['parent_id']) ? $this->getReference('cb-menu-'.$data['parent_id']) : null))
            ->setOrderNr($data['orderNr'])
            ->setName($data['name'])
            ->setEnableLink($data['enableLink'])
            ->setLink($data['link'])
            ->setRouteName($data['routeName'])
            ->setRouteParams($data['routeParams'])
            ->setClass($data['class'])
            ->setAdvanced($data['advanced'])
            ->setPermission($data['permission'])
        ;
    }
}
