<?php

namespace Wi\Admin\CoreBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Wi\Admin\CoreBundle\Entity\Config;
use Wi\Admin\NewsBundle\Comment\CommentEngineInterface;

/**
 * Załadowanie ustawień do bazy danych.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LoadConfigData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritdoc}
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->getData() as $data) {
            $config = $this->getConfig($data);

            // Przygotowanie do zapisu.
            $manager->persist($config);

            // Wymuszenie podania ID.
            $metadata = $manager->getClassMetaData(get_class($config));
            $metadata->setIdGeneratorType(\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_NONE);
        }

        // Zapis.
        $manager->flush();
    }

    /**
     * {@inheritdoc}
     */
    public function getOrder()
    {
        return 1;
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Tablica danych.
     *
     * @return mixed[]
     */
    private function getData()
    {
        return [
            ['id' => 1, 'groupName' => 'news', 'name' => 'imageWidth', 'value' => 1920],
            ['id' => 2, 'groupName' => 'news', 'name' => 'imageHeight', 'value' => 1353],
            ['id' => 3, 'groupName' => 'news', 'name' => 'thumbnailWidth', 'value' => 600],
            ['id' => 4, 'groupName' => 'news', 'name' => 'thumbnailHeight', 'value' => 400],
            ['id' => 5, 'groupName' => 'news', 'name' => 'thumbnailSWidth', 'value' => 370],
            ['id' => 6, 'groupName' => 'news', 'name' => 'thumbnailSHeight', 'value' => 260],
            ['id' => 7, 'groupName' => 'goal', 'name' => 'imageWidth', 'value' => 2022],
            ['id' => 8, 'groupName' => 'goal', 'name' => 'imageHeight', 'value' => 1280],
            ['id' => 9, 'groupName' => 'goal', 'name' => 'thumbnailWidth', 'value' => 700],
            ['id' => 10, 'groupName' => 'goal', 'name' => 'thumbnailHeight', 'value' => 438],
            ['id' => 11, 'groupName' => 'goal', 'name' => 'thumbnailSWidth', 'value' => 370],
            ['id' => 12, 'groupName' => 'goal', 'name' => 'thumbnailSHeight', 'value' => 238],
            ['id' => 13, 'groupName' => 'auction', 'name' => 'imageWidth', 'value' => 2022],
            ['id' => 14, 'groupName' => 'auction', 'name' => 'imageHeight', 'value' => 1280],
            ['id' => 15, 'groupName' => 'auction', 'name' => 'thumbnailWidth', 'value' => 700],
            ['id' => 16, 'groupName' => 'auction', 'name' => 'thumbnailHeight', 'value' => 438],
            ['id' => 17, 'groupName' => 'auction', 'name' => 'thumbnailSWidth', 'value' => 370],
            ['id' => 18, 'groupName' => 'auction', 'name' => 'thumbnailSHeight', 'value' => 238],
            ['id' => 19, 'groupName' => 'og', 'name' => 'newsType', 'value' => 'news'],
            ['id' => 20, 'groupName' => 'og', 'name' => 'pageType', 'value' => 'article'],
            ['id' => 21, 'groupName' => 'og', 'name' => 'auctionType', 'value' => 'news'],
            ['id' => 22, 'groupName' => 'og', 'name' => 'goalType', 'value' => 'news'],
            ['id' => 23, 'groupName' => 'google', 'name' => 'apiKey', 'value' => null],
            ['id' => 24, 'groupName' => 'recaptcha', 'name' => 'siteKey', 'value' => null],
            ['id' => 25, 'groupName' => 'recaptcha', 'name' => 'secretKey', 'value' => null],
            ['id' => 26, 'groupName' => 'metadata', 'name' => 'title', 'value' => 'WEBimpuls WiCMS'],
            ['id' => 27, 'groupName' => 'metadata', 'name' => 'description', 'value' => 'Twój opis strony'],
            ['id' => 28, 'groupName' => 'metadata', 'name' => 'keywords', 'value' => 'Twoje słowa kluczowe'],
            ['id' => 29, 'groupName' => 'metadata', 'name' => 'titleForAllPages', 'value' => '1'],
            ['id' => 30, 'groupName' => 'metadata', 'name' => 'titleSeparator', 'value' => ' - '],
            ['id' => 31, 'groupName' => 'metadata', 'name' => 'keywordsEnable', 'value' => '1'],
            ['id' => 32, 'groupName' => 'metadata', 'name' => 'keywordsForAllPages', 'value' => '0'],
            ['id' => 33, 'groupName' => 'metadata', 'name' => 'openGraphEnable', 'value' => '0'],
            ['id' => 34, 'groupName' => 'metadata', 'name' => 'openGraphDefaultImage', 'value' => null],
            ['id' => 35, 'groupName' => 'metadata', 'name' => 'canonical', 'value' => '1'],
            ['id' => 36, 'groupName' => 'metadata', 'name' => 'canonicalForce', 'value' => '0'],
            ['id' => 37, 'groupName' => 'metadata', 'name' => 'otherHead', 'value' => null],
            ['id' => 38, 'groupName' => 'google', 'name' => 'gaTracking', 'value' => null],
            ['id' => 39, 'groupName' => 'seo', 'name' => 'metaTitleLengthFrom', 'value' => '40'],
            ['id' => 40, 'groupName' => 'seo', 'name' => 'metaTitleLengthTo', 'value' => '64'],
            ['id' => 41, 'groupName' => 'seo', 'name' => 'metaDescriptionLengthFrom', 'value' => '140'],
            ['id' => 42, 'groupName' => 'seo', 'name' => 'metaDescriptionLengthTo', 'value' => '180'],
            ['id' => 43, 'groupName' => 'cookie', 'name' => 'enable', 'value' => '1'],
            ['id' => 44, 'groupName' => 'cookie', 'name' => 'type', 'value' => 'top_static'],
            ['id' => 45, 'groupName' => 'cookie', 'name' => 'buttonLabel', 'value' => 'OK'],
            ['id' => 46, 'groupName' => 'cookie', 'name' => 'content', 'value' => 'Ta strona używa plików Cookie. Korzystając z tej strony zgadzasz się na umieszczenie tych plików na twoim urządzeniu'],
            ['id' => 47, 'groupName' => 'sitemap', 'name' => 'multifile', 'value' => 0],
            ['id' => 48, 'groupName' => 'sitemap', 'name' => 'splitPagesPerGroup', 'value' => 0],
            ['id' => 49, 'groupName' => 'sitemap', 'name' => 'splitNewsPerCategory', 'value' => 0],
            ['id' => 50, 'groupName' => 'sitemap', 'name' => 'splitNewsPerMonth', 'value' => 0],
            ['id' => 51, 'groupName' => 'sitemap', 'name' => 'splitGalleriesPerAlbum', 'value' => 0],
            ['id' => 52, 'groupName' => 'sitemap', 'name' => 'includePageImage', 'value' => 0],
            ['id' => 53, 'groupName' => 'sitemap', 'name' => 'includeNewsImage', 'value' => 0],
            ['id' => 54, 'groupName' => 'sitemap', 'name' => 'includeGalleryImages', 'value' => 0],
            ['id' => 55, 'groupName' => 'sitemap', 'name' => 'showImagePublicIndex', 'value' => 0],
            ['id' => 56, 'groupName' => 'google', 'name' => 'gaViewId', 'value' => null],
            ['id' => 57, 'groupName' => 'google', 'name' => 'gaJson', 'value' => null],
            ['id' => 58, 'groupName' => 'blog', 'name' => 'imageWidth', 'value' => 1920],
            ['id' => 59, 'groupName' => 'blog', 'name' => 'imageHeight', 'value' => 1353],
            ['id' => 60, 'groupName' => 'blog', 'name' => 'thumbnailWidth', 'value' => 600],
            ['id' => 61, 'groupName' => 'blog', 'name' => 'thumbnailHeight', 'value' => 400],
            ['id' => 62, 'groupName' => 'blog', 'name' => 'thumbnailSWidth', 'value' => 370],
            ['id' => 63, 'groupName' => 'blog', 'name' => 'thumbnailSHeight', 'value' => 260],
            ['id' => 64, 'groupName' => 'cache', 'name' => 'enable', 'value' => 1],
            ['id' => 65, 'groupName' => 'cache', 'name' => 'lifetimePage', 'value' => 900],
            ['id' => 66, 'groupName' => 'cache', 'name' => 'lifetimeNews', 'value' => 900],
            ['id' => 67, 'groupName' => 'cache', 'name' => 'lifetimeNewsList', 'value' => 900],
            ['id' => 68, 'groupName' => 'cache', 'name' => 'imageEnable', 'value' => 1],
            ['id' => 69, 'groupName' => 'cache', 'name' => 'imageLifetime', 'value' => 2592000],
            ['id' => 70, 'groupName' => 'cache', 'name' => 'scriptEnable', 'value' => 1],
            ['id' => 71, 'groupName' => 'cache', 'name' => 'scriptLifetime', 'value' => 2592000],
            ['id' => 72, 'groupName' => 'cache', 'name' => 'styleEnable', 'value' => 1],
            ['id' => 73, 'groupName' => 'cache', 'name' => 'styleLifetime', 'value' => 2592000],
            ['id' => 74, 'groupName' => 'cache', 'name' => 'docEnable', 'value' => 1],
            ['id' => 75, 'groupName' => 'cache', 'name' => 'docLifetime', 'value' => 2592000],
            ['id' => 76, 'groupName' => 'banner', 'name' => 'imageWidth', 'value' => 1920],
            ['id' => 77, 'groupName' => 'banner', 'name' => 'imageHeight', 'value' => 500],
            ['id' => 78, 'groupName' => 'banner', 'name' => 'thumbnailWidth', 'value' => 384],
            ['id' => 79, 'groupName' => 'banner', 'name' => 'thumbnailHeight', 'value' => 100],
            ['id' => 80, 'groupName' => 'comment', 'name' => 'enable', 'value' => CommentEngineInterface::WICMS],
            ['id' => 81, 'groupName' => 'comment', 'name' => 'enableLoginButton', 'value' => 1],
            ['id' => 82, 'groupName' => 'comment', 'name' => 'enableUserAutoAccept', 'value' => 1],
            ['id' => 83, 'groupName' => 'comment', 'name' => 'enableGuestAutoAccept', 'value' => 1],
            ['id' => 84, 'groupName' => 'comment', 'name' => 'enableGuest', 'value' => 1],
            ['id' => 85, 'groupName' => 'comment', 'name' => 'enableUserLimit', 'value' => 0],
            ['id' => 86, 'groupName' => 'comment', 'name' => 'userLimitValue', 'value' => 60],
            ['id' => 87, 'groupName' => 'comment', 'name' => 'enableGuestLimit', 'value' => 0],
            ['id' => 88, 'groupName' => 'comment', 'name' => 'guestLimitValue', 'value' => 60],
            ['id' => 89, 'groupName' => 'comment', 'name' => 'disqusShortname', 'value' => null],
            ['id' => 90, 'groupName' => 'comment', 'name' => 'fbAppId', 'value' => null],
            ['id' => 91, 'groupName' => 'cookie', 'name' => 'skin', 'value' => 'dark'],
            ['id' => 92, 'groupName' => 'google', 'name' => 'gaUserId', 'value' => null],
            ['id' => 93, 'groupName' => 'user', 'name' => 'autoAccept', 'value' => 1],
            ['id' => 94, 'groupName' => 'user', 'name' => 'confirmEmail', 'value' => 0],
            ['id' => 95, 'groupName' => 'user', 'name' => 'notifyAdmin', 'value' => 0],
            ['id' => 96, 'groupName' => 'user', 'name' => 'notifyAdminList', 'value' => null],
            ['id' => 97, 'groupName' => 'user', 'name' => 'imageWidth', 'value' => 150],
            ['id' => 98, 'groupName' => 'user', 'name' => 'imageHeight', 'value' => 150],
        ];
    }

    /**
     * Tworzy obiekt nowego wpisu konfiguracji na podstawie przekazanej
     * tablicy danych.
     *
     * @param   array $data
     * @return  \Wi\Admin\CoreBundle\Entity\Config
     */
    private function getConfig(array $data)
    {
        return (new Config())
            ->setId($data['id'])
            ->setGroupName($data['groupName'])
            ->setName($data['name'])
            ->setValue($data['value'])
        ;
    }
}
