<?php

namespace Wi\Admin\CoreBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Wi\Admin\ContactBundle\Entity\Form;

/**
 * Seo controller.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class SeoController extends Controller
{
    /**
     * Główny widok menadżera SEO.
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();
        $pages = $em->getRepository('WiAdminPageBundle:Page')->findAll();
        $news = $em->getRepository('WiAdminNewsBundle:News')->findAll();
        $newsCategories = $em->getRepository('WiAdminNewsBundle:Category')->findAll();
        $forms = $em->getRepository('WiAdminContactBundle:Form')->findByFormType(Form::TYPE_CONTACT);

        return $this->render('WiAdminCoreBundle:Seo:index.html.php', [
            'forms' => $forms,
            'newsCategories' => $newsCategories,
            'news' => $news,
            'pages' => $pages,
        ]);
    }
}
