<?php

namespace Wi\Admin\CoreBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Wi\Admin\CoreBundle\Entity\Message;
use Wi\Admin\CoreBundle\Utils\StrefaWiCMSAPI;

class MessageController extends Controller
{

    /**
     * Obsługa formularza na stronie błędu 500 ajaxem.
     *
     * @param   Request $request
     * @return  JsonResponse
     */
    public function sendErrorAction(Request $request)
    {

        // Obsługa formularzy.
        if ($request->get('errorInfo')){
            $errorInfo = $request->get('errorInfo');
            $publicId = $this->getParameter('public_id');
            $id = $request->get('id');

            // Wysłanie sugestii do Strefy WiCMS.
            $api = new StrefaWiCMSAPI();
            $params = [
                'comment' => $errorInfo,
                'publicID' => $publicId,
            ];
            $api->errorPut($id, $params);
        }

        return new JsonResponse(true);
    }

    /**
     * Obsługa formularza ajaxem, wysłanie wiadomości do działu technicznego.
     *
     * @param   Request $request
     * @return  Response
     */
    public function sendMessagesAction(Request $request)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();

        // Utworzenie nowego obiektu Suggestions.
        $message = new Message();

        $sendApi = false;
        // Obsługa formularzy.
        if ($request->get('content')){
            $message->setContent($request->get('content'));
            $message->setName($request->get('name'));
            $message->setAdmin($this->getUser());
            $message->setUrl($request->get('url'));
            $message->setFormName($request->get('formName'));
            // Przygotowanie do zapisu.
            $em->persist($message);

            // Zapis.
            $em->flush();

            // Wysłanie sugestii do Strefy WiCMS.
            $api = new StrefaWiCMSAPI();
            $params = [
                'publicID' => $this->getParameter('public_id'),       //identyfikator instalacji
                'version' => $this->getParameter('version'),        //numer wersji WiCMS-a,
                'administrator' => $message->getAdmin()->getLogin(),     //login administratora
                'currentUrl' => $message->getUrl(),     //adres, skąd wysłano sugestię
                'message' => $message->getContent(),        //treść sugestii
                'email' => $message->getName(),      //imię osoby która wysłała sugestię
            ];
            $sendApi = $api->supportMessagePost($params);

        }

        return new JsonResponse($sendApi);
    }

}
