<?php

namespace Wi\Admin\CoreBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Wi\Admin\CoreBundle\Form\Cache\CacheType;
use Wi\Admin\CoreBundle\Service\Cache as CacheService;

/**
 * Cache controller.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2018 WEBimpuls Sp. z o.o.
 */
class CacheController extends Controller
{
    /**
     * Zarzadzanie konfiguracją systemu cache'owania.
     *
     * @param Request $request
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction(Request $request, CacheService $cacheService)
    {
        $form = $this->createForm(CacheType::class);
        $form->handleRequest($request);

        // Weryfikacja, czy formularz został przesłany i pomyślnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
            $data = $form->getData();

            foreach ($data as $config => $value) {
                $arr = explode('_', $config);

                if (in_array($arr[1], [
                    'enable',
                    'lifetimePage',
                    'lifetimeNews',
                    'lifetimeNewsList',
                    'imageEnable',
                    'imageLifetime',
                    'scriptEnable',
                    'scriptLifetime',
                    'styleEnable',
                    'styleLifetime',
                    'docEnable',
                    'docLifetime',
                ])) {
                    $value = intval($value);
                }

                $this->get('config')->save(
                    $arr[0],
                    $arr[1],
                    $value
                );

                if ($arr[1] == 'enable' && ! boolval($value)) {
                    $this->deleteTree($this->getParameter('kernel.cache_dir').'/../prod/http_cache/');
                }

                $cacheService->rebuild();
            }

            return $this->redirectToRoute('wi_admin_core_cache_index');
        }

        return $this->render('WiAdminCoreBundle:Cache:index.html.php', [
            'form' => $form->createView(),
        ]);
    }

    // -------------------------------------------------------------------------

    private function deleteTree($dir)
    {
        if (file_exists($dir)) {
            $files = array_diff(scandir($dir), ['.', '..']);

            foreach ($files as $file) {
                if (is_dir($dir.$file)) {
                    $this->deleteTree($dir.$file.'/');
                } else {
                    unlink($dir.$file);
                }
            }

            return rmdir($dir);
        }
    }
}
