<?php

namespace Wi\Admin\CoreBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Wi\Admin\CoreBundle\Service\Backup\BackupManager;

/**
 * Backup controller.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class BackupController extends Controller
{
    /**
     * Backup - widok główny.
     *
     * @param BackupManager $backupManager
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function databaseAction(BackupManager $backupManager)
    {
        $backupList = $backupManager->getBackupList();

        return $this->render('WiAdminCoreBundle:Backup:database.html.php', [
            'backupList' => $backupList,
        ]);
    }

    /**
     * Wygenerowanie kopii zapasowej.
     *
     * @param BackupManager $backupManager
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function generateAction(BackupManager $backupManager)
    {
        $backupManager->backup();

        return $this->redirectToRoute('wi_admin_core_backup_database');
    }

    /**
     * Pobranie pliku kopii zapasowej.
     *
     * @param BackupManager $backupManager
     * @param string $filename
     * @return \Symfony\Component\HttpFoundation\BinaryFileResponse
     */
    public function downloadAction(BackupManager $backupManager, $filename)
    {
        if ($file = $backupManager->getBackupFile($filename)) {
            return $this->file($file, $filename);
        }

        return $this->redirectToRoute('wi_admin_core_backup_database');
    }

    /**
     * Usunięcie pliku kopii zapasowej.
     *
     * @param BackupManager $backupManager
     * @param string $filename
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function removeAction(BackupManager $backupManager, $filename)
    {
        $backupManager->removeFile($filename);

        return $this->redirectToRoute('wi_admin_core_backup_database');
    }

    /**
     * Przywrócenie kopii zapasowej z pliku.
     *
     * @param BackupManager $backupManager
     * @param string $filename
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function restoreAction(BackupManager $backupManager, $filename)
    {
        $backupManager->restoreFile($filename);

        return $this->redirectToRoute('wi_admin_core_backup_database');
    }
}
